/*
 * Decompiled with CFR 0.152.
 */
package freak.module.view;

import freak.core.control.Schedule;
import freak.core.fitness.FitnessFunction;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.view.AbstractView;
import freak.core.view.swingsupport.FreakSwingModel;
import freak.core.view.swingsupport.UpdateManager;
import freak.module.searchspace.BooleanFunction;
import freak.module.searchspace.BooleanFunctionGenotype;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import javax.swing.BorderFactory;
import javax.swing.JPanel;

public class CountZeroView
extends AbstractView
implements Configurable,
FreakSwingModel {
    private transient JPanel panel;
    private static final float MAXIMAL_HUE = 0.8f;
    private static float SATURATION = 1.0f;
    private static float BRIGHTNESS = 1.0f;
    private static Color DEFAULT_COLOR = Color.red;
    private IndividualList individuals;
    private boolean colorByFitness;
    private boolean displayOptimum = this.supportsDisplayOptimum();
    private int maximalNumberOfIndividuals = 1000;
    int counter = 1;

    public CountZeroView(Schedule schedule) {
        super(schedule);
        this.colorByFitness = this.supportsUseColor();
    }

    public void initialize() {
        super.initialize();
        this.displayOptimum &= this.supportsDisplayOptimum();
        this.colorByFitness &= this.supportsUseColor();
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getGenotypeSearchSpace() instanceof BooleanFunction)) {
            throw new UnsupportedEnvironmentException("Unsupported searchspace.");
        }
    }

    public JPanel createPanel() {
        this.panel = new CountViewPanel(this);
        return this.panel;
    }

    private boolean supportsUseColor() {
        if (!(this.getSchedule().getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            return false;
        }
        SingleObjectiveFitnessFunction fitness = (SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction();
        try {
            fitness.getLowerBound();
            fitness.getUpperBound();
            return true;
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    private boolean supportsDisplayOptimum() {
        FitnessFunction fitness = this.getSchedule().getFitnessFunction();
        try {
            fitness.getGenotypeOptimum();
            return true;
        }
        catch (UnsupportedOperationException ex) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Object data) {
        int wert;
        int generation = this.schedule.getCurrentGeneration();
        if (generation == (wert = 10 * this.counter) | generation == 1) {
            super.update(data);
            CountZeroView countZeroView = this;
            synchronized (countZeroView) {
                this.individuals = (IndividualList)data;
            }
            UpdateManager.markDirty(this);
            ++this.counter;
        }
    }

    public void flush() {
        if (this.panel == null) {
            return;
        }
        this.panel.repaint();
    }

    public String getName() {
        return "Count zero";
    }

    public String getDescription() {
        return "";
    }

    public Class[] getInputDataTypes() {
        return new Class[]{IndividualList.class};
    }

    public Color getColorByFitness(Individual individual) {
        if (!this.colorByFitness) {
            return DEFAULT_COLOR;
        }
        try {
            SingleObjectiveFitnessFunction fitness = (SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction();
            double lowerFitnessBound = fitness.getLowerBound();
            double upperFitnessBound = fitness.getUpperBound();
            double fitnessValue = fitness.evaluate(individual, this.individuals);
            double normalizedFitnessValue = (fitnessValue - lowerFitnessBound) / (upperFitnessBound - lowerFitnessBound);
            Color result = new Color(Color.HSBtoRGB((float)(1.0 - normalizedFitnessValue) * 0.8f, SATURATION, BRIGHTNESS));
            return result;
        }
        catch (UnsupportedOperationException ex) {
            return DEFAULT_COLOR;
        }
    }

    public IndividualList getIndividualList() {
        return this.individuals;
    }

    public void setPropertyColorByFitness(Boolean colorByFitness) {
        this.colorByFitness = colorByFitness != false && this.supportsUseColor();
    }

    public Boolean getPropertyColorByFitness() {
        return new Boolean(this.colorByFitness);
    }

    public String getShortDescriptionForColorByFitness() {
        return "Color individuals by fitness";
    }

    public String getLongDescriptionForColorByFitness() {
        return "Colors the displayed individuals by their fitness on a scale from violet (least fitness) to red (highest fitness). This feature can only be enabled if the fitness function knows the optimal fitness value.";
    }

    public void setPropertyDisplayOptimum(Boolean displayOptimum) {
        this.displayOptimum = displayOptimum != false && this.supportsDisplayOptimum();
    }

    public Boolean getPropertyDisplayOptimum() {
        return new Boolean(this.displayOptimum);
    }

    public String getShortDescriptionForDisplayOptimum() {
        return "Display global optimum";
    }

    public String getLongDescriptionForDisplayOptimum() {
        return "Displays the global optimum in the CountView. This option can only be enabled if a global optimum exists and if the fitness function knows the optimum.";
    }

    public void setPropertyMaximalNumberOfIndividuals(Integer number) {
        if (number > 0) {
            this.maximalNumberOfIndividuals = number;
        }
    }

    public Integer getPropertyMaximalNumberOfIndividuals() {
        return new Integer(this.maximalNumberOfIndividuals);
    }

    public String getShortDescriptionForMaximalNumberOfIndividuals() {
        return "Maximal number of individuals";
    }

    public String getLongDescriptionForMaximalNumberOfIndividuals() {
        return "Sets the maximal number of individuals displayed in the CountView. If more individuals are to be displayed, only the first ones are shown.";
    }

    class CountViewPanel
    extends JPanel {
        public static final double X_SCALE = 0.8;
        public static final int MAX_POINT_SIZE = 8;
        private Insets insets;
        private int currentWidth;
        private int currentHeight;
        private Graphics graphics;
        private CountZeroView CountView;

        public CountViewPanel(CountZeroView CountView) {
            this.CountView = CountView;
            this.setBackground(Color.white);
            this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            this.graphics = g;
            this.insets = this.getInsets();
            this.currentWidth = this.getWidth() - this.insets.left - this.insets.right;
            this.currentHeight = this.getHeight() - this.insets.top - this.insets.bottom;
            g.setColor(Color.black);
            this.drawSearchSpace();
            CountZeroView countZeroView = this.CountView;
            synchronized (countZeroView) {
                IndividualList individuals = this.CountView.getIndividualList();
                if (individuals != null) {
                    Individual individual;
                    int maxAnzahl = 0;
                    int minAnzahl = 0;
                    int minFitness = 0;
                    int maxFitness = 0;
                    int i = 0;
                    while (i < individuals.size()) {
                        individual = individuals.getIndividual(i);
                        int anzahlNullen = ((BooleanFunctionGenotype)individual.getGenotype()).evaluate() - ((BooleanFunctionGenotype)individual.getGenotype()).evaluate1s();
                        int fitness = ((BooleanFunctionGenotype)individual.getGenotype()).evaluate();
                        if (i == 0) {
                            minAnzahl = anzahlNullen;
                            minFitness = fitness;
                        }
                        if (anzahlNullen > maxAnzahl) {
                            maxAnzahl = anzahlNullen;
                        }
                        if (anzahlNullen < minAnzahl) {
                            minAnzahl = anzahlNullen;
                        }
                        if (fitness > maxFitness) {
                            maxFitness = fitness;
                        }
                        if (fitness < minFitness) {
                            minFitness = fitness;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < individuals.size()) {
                        individual = individuals.getIndividual(i);
                        g.setColor(this.CountView.getColorByFitness(individual));
                        this.drawIndividual(maxFitness, minFitness, maxAnzahl, minAnzahl, ((BooleanFunctionGenotype)individual.getGenotype()).evaluate(), ((BooleanFunctionGenotype)individual.getGenotype()).evaluate() - ((BooleanFunctionGenotype)individual.getGenotype()).evaluate1s());
                        ++i;
                    }
                }
                if (this.CountView.displayOptimum) {
                    try {
                        Genotype optimum = this.CountView.getSchedule().getFitnessFunction().getGenotypeOptimum();
                    }
                    catch (UnsupportedOperationException unsupportedOperationException) {
                        // empty catch block
                    }
                }
            }
        }

        private void drawSearchSpace() {
            this.graphics.setColor(Color.black);
            int y = 0;
            while (y <= this.currentHeight) {
                this.drawPixel(this.insets.left + 10, y + this.insets.top);
                ++y;
            }
            int x = 0;
            while (x <= this.currentWidth) {
                this.drawPixel(x + this.insets.left + 10, this.currentHeight + this.insets.top);
                ++x;
            }
            this.graphics.drawLine(this.currentWidth + this.insets.left + 5, this.currentHeight + this.insets.top - 5, this.currentWidth + this.insets.left + 10, this.currentHeight + this.insets.top);
            this.graphics.drawLine(this.currentWidth + this.insets.left + 5, this.currentHeight + this.insets.top + 5, this.currentWidth + this.insets.left + 10, this.currentHeight + this.insets.top);
            this.graphics.drawString("Fitness", this.currentWidth - 30, this.currentHeight);
            this.graphics.drawLine(this.insets.left + 5, this.insets.top + 5, this.insets.left + 10, this.insets.top);
            this.graphics.drawLine(this.insets.left + 15, this.insets.top + 5, this.insets.left + 10, this.insets.top);
            this.graphics.drawString("Anzahl 0", this.insets.left + 10, this.insets.top + 10);
        }

        private void drawXAchsenBeschriftung(int minFitness, int maxFitness) {
            this.graphics.setColor(Color.black);
            int diff = maxFitness - minFitness;
            float i = 0.0f;
            while (i < 4.0f) {
                this.graphics.drawLine((int)((double)this.currentWidth * ((double)(i + 1.0f) / 4.0)), this.currentHeight + 5, (int)((double)this.currentWidth * ((double)(i + 1.0f) / 4.0)), this.currentHeight + 10);
                if (i == 0.0f) {
                    this.graphics.drawString(Integer.toString(maxFitness - diff), (int)((double)this.currentWidth * ((double)(i + 1.0f) / 4.0) - 10.0), this.currentHeight + 20);
                } else {
                    this.graphics.drawString(Integer.toString((int)((double)(maxFitness - diff) + (double)diff * ((double)i / 3.0))), (int)((double)this.currentWidth * ((double)(i + 1.0f) / 4.0) - 10.0), this.currentHeight + 20);
                }
                i += 1.0f;
            }
        }

        private void drawYAchsenBeschriftung(int minAnzahl, int maxAnzahl) {
            this.graphics.setColor(Color.black);
            int diff = maxAnzahl - minAnzahl;
            float i = 0.0f;
            while (i <= 3.0f) {
                this.graphics.drawLine(this.insets.left + 5, (int)((double)this.insets.top + (double)this.currentHeight * ((double)((float)(4.0 - (double)(i + 1.0f))) / 4.0)), this.insets.left + 15, (int)((double)this.insets.top + (double)this.currentHeight * ((double)((float)(4.0 - (double)(i + 1.0f))) / 4.0)));
                if (i == 0.0f) {
                    this.graphics.drawString(Integer.toString(maxAnzahl - diff), this.insets.left - 10, (int)((double)this.insets.top + (double)this.currentHeight * ((double)((float)(4.0 - (double)(i + 1.0f))) / 4.0)));
                } else {
                    this.graphics.drawString(Integer.toString(maxAnzahl - diff + (int)((double)diff * ((double)i / 3.0))), this.insets.left - 10, (int)((double)this.insets.top + (double)this.currentHeight * ((double)((float)(4.0 - (double)(i + 1.0f))) / 4.0)));
                }
                i += 1.0f;
            }
        }

        private int getXDeviation(int y) {
            return (int)(Math.sin(Math.PI * ((double)y / (double)this.currentHeight)) * this.getXScale());
        }

        private double getXScale() {
            return (double)this.currentWidth * 0.4;
        }

        private void drawIndividual(int maxFitness, int minFitness, int maxAnzahl, int minAnzahl, int fitness, int anzahlNullen) {
            int radius = this.getPointSize();
            if (maxFitness == minFitness) {
                --minFitness;
            }
            if (maxAnzahl == minAnzahl) {
                --minAnzahl;
            }
            int diffFitness = maxFitness - minFitness + 1;
            int diffAnzahl = maxAnzahl - minAnzahl + 1;
            Point point = new Point((int)((double)this.currentWidth / 4.0 + (double)((float)((double)this.currentWidth - (double)this.currentWidth / 4.0) / (float)diffFitness * (float)(fitness - (maxFitness - diffFitness)))), (int)((double)(this.currentHeight + 2 * this.insets.top) - ((double)this.insets.top + (double)(this.currentHeight + this.insets.top) * 0.25) - (double)(((float)this.currentHeight - (float)(this.currentHeight + this.insets.top * 2) / 4.0f) / (float)diffAnzahl * (float)(anzahlNullen - (maxAnzahl - diffAnzahl)))));
            this.graphics.fillOval((int)point.getX() - (radius + 1) / 2 + 1, (int)point.getY() - (radius + 1) / 2, radius, radius);
            this.drawYAchsenBeschriftung(minAnzahl, maxAnzahl);
            this.drawXAchsenBeschriftung(minFitness, maxFitness);
        }

        private void drawPixel(int x, int y) {
            this.graphics.drawLine(x - 1, y, x + 1, y);
        }

        private int getPointSize() {
            return Math.max(1, Math.min(8, this.currentHeight / 50));
        }
    }
}

