/*
 * Decompiled with CFR 0.152.
 */
package freak.module.operator.split;

import edu.cornell.lassp.houle.RngPack.RandomElement;
import freak.core.graph.CompatibleWithDifferentSearchSpaces;
import freak.core.graph.GraphException;
import freak.core.graph.HasFloatingNumberOfOutPorts;
import freak.core.graph.OperatorGraph;
import freak.core.graph.Split;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.population.Population;

public class RandomPartition
extends Split
implements HasFloatingNumberOfOutPorts,
CompatibleWithDifferentSearchSpaces {
    private boolean exact;

    public RandomPartition(OperatorGraph graph) {
        super(graph);
    }

    public IndividualList[] process(IndividualList[] input) throws GraphException {
        int outPorts = this.getNumberOfOutPorts();
        if (outPorts == 0) {
            return new IndividualList[0];
        }
        if (outPorts == 1) {
            return input;
        }
        int inputLength = input[0].size();
        if (this.exact && inputLength % outPorts != 0) {
            throw new GraphException("The number of individuals (" + inputLength + ") is not a multiple of the number of outports (" + outPorts + ").");
        }
        int sizeOfSubSet = inputLength / outPorts;
        int bound = inputLength;
        RandomElement re = this.getOperatorGraph().getSchedule().getRandomElement();
        Individual[] ind = input[0].toArray();
        int i = 0;
        while (i < bound) {
            int pos = re.choose(i, inputLength - 1);
            Individual temp = ind[i];
            ind[i] = ind[pos];
            ind[pos] = temp;
            ++i;
        }
        IndividualList[] output = new IndividualList[outPorts];
        int i2 = 0;
        while (i2 < outPorts) {
            output[i2] = new Population(this.getOperatorGraph().getSchedule());
            int j = 0;
            while (j < sizeOfSubSet) {
                output[i2].addIndividual(ind[i2 * sizeOfSubSet + j]);
                ++j;
            }
            ++i2;
        }
        if (!this.exact) {
            int remaining = inputLength - sizeOfSubSet * outPorts;
            int[] a = new int[outPorts];
            int i3 = 0;
            while (i3 < outPorts) {
                a[i3] = i3;
                ++i3;
            }
            i3 = 0;
            while (i3 < remaining) {
                int change = re.choose(i3, outPorts - 1);
                int tmp = a[change];
                a[change] = a[i3];
                a[i3] = tmp;
                output[a[i3]].addIndividual(ind[sizeOfSubSet * outPorts + i3]);
                ++i3;
            }
        }
        return output;
    }

    public String getDescription() {
        return "This operators splits the set of incoming individuals randomly into a given number of subsets of equal size.";
    }

    public String getName() {
        return "Random Partition";
    }

    public Boolean getPropertyExact() {
        return new Boolean(this.exact);
    }

    public void setPropertyExact(Boolean exact) {
        this.exact = exact;
    }

    public String getShortDescriptionForExact() {
        return "Exact";
    }

    public String getLongDescriptionForExact() {
        return "If checked, the number of incoming individuals must be a multiple of the number of outports. If unchecked and the number of incoming individuals is not a multiple of the number of outports, some randomly chosen outports get one individual more than the others.";
    }
}

