/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer.isingmodelcliques;

import freak.core.control.Schedule;
import freak.core.event.BatchEvent;
import freak.core.event.BatchEventListener;
import freak.core.event.EventListener;
import freak.core.event.IndividualListEvent;
import freak.core.event.IndividualListEventListener;
import freak.core.event.RunEvent;
import freak.core.event.RunEventListener;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.AbstractObserver;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.module.fitness.generalstring.IsingModelCliques;
import freak.module.observer.isingmodelcliques.CliquesMonochromaticBridges;
import freak.module.searchspace.GeneralString;

public class CliquesBridgeBasedSuccessPrediction
extends AbstractObserver
implements BatchEventListener,
RunEventListener,
IndividualListEventListener,
Configurable {
    private int totalRuns;
    private int successfullyPredictedRuns;
    private int generation = 0;
    private boolean prediction = false;
    private int currentRun = 0;
    private CliquesMonochromaticBridges potentialFunction;

    public CliquesBridgeBasedSuccessPrediction(Schedule schedule) {
        super(schedule);
        this.setMeasure(3);
        this.potentialFunction = new CliquesMonochromaticBridges(schedule);
        if (schedule.getPhenotypeSearchSpace() instanceof GeneralString) {
            this.generation = ((GeneralString)this.getSchedule().getPhenotypeSearchSpace()).getDimension();
        }
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        if (!(schedule.getRealFitnessFunction() instanceof IsingModelCliques)) {
            throw new UnsupportedEnvironmentException("This module works on Ising Model Cliques only.");
        }
        this.potentialFunction.testSchedule(schedule);
    }

    public void initialize() {
        super.initialize();
        this.potentialFunction.initialize();
    }

    public Class getOutputDataType() {
        return Double.class;
    }

    public String getName() {
        return "Cliques Success Prediction (bridge based)";
    }

    public String getDescription() {
        return "Computes the quota of correctly predicted runs. The success of a run is predicted by the rate of monochromatic bridges. If after the specified number of generations, the rate of monochromatic bridges is greater than 1/2, the run is predicted to besuccessful.";
    }

    public void createEvents() {
        super.createEvents();
        this.schedule.getEventController().addEvent((EventListener)this, BatchEvent.class, this.schedule);
        this.schedule.getEventController().addEvent((EventListener)this, IndividualListEvent.class, this.schedule.getPopulationManager());
        this.schedule.getEventController().addEvent((EventListener)this, RunEvent.class, this.schedule);
    }

    public void batchFinished(BatchEvent evt) {
        this.updateViews(new Double((double)this.successfullyPredictedRuns / (double)this.totalRuns));
        this.totalRuns = 0;
        this.successfullyPredictedRuns = 0;
    }

    public void setPropertyGeneration(Integer i) {
        if (i >= 0) {
            this.generation = i;
        }
    }

    public Integer getPropertyGeneration() {
        return new Integer(this.generation);
    }

    public void individualList(IndividualListEvent evt) {
        super.individualList(evt);
        if (this.getSchedule().getCurrentGeneration() == this.generation) {
            IndividualList population = this.getSchedule().getPopulationManager().getPopulation();
            Individual elitist = population.getIndividualWithRank(1);
            double potential = this.potentialFunction.computePotentialFunction(elitist);
            this.prediction = potential > 0.5;
            this.currentRun = this.getSchedule().getCurrentRun();
        }
    }

    public void runFinalize(RunEvent evt) {
        super.runFinalize(evt);
        if (this.getSchedule().getCurrentRun() == this.currentRun) {
            boolean success;
            IndividualList population = this.getSchedule().getPopulationManager().getPopulation();
            Individual elitist = population.getIndividualWithRank(1);
            SingleObjectiveFitnessFunction fitnessFunction = (SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction();
            double bestFitness = fitnessFunction.evaluate(elitist, population);
            boolean bl = success = bestFitness >= fitnessFunction.getOptimalFitnessValue();
            if (this.prediction == success) {
                ++this.successfullyPredictedRuns;
            }
            ++this.totalRuns;
        }
    }
}

