/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer;

import freak.core.control.Schedule;
import freak.core.event.IndividualListEvent;
import freak.core.event.IndividualListEventListener;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.AbstractObserver;
import freak.core.population.Genotype;
import freak.core.population.Individual;
import freak.core.population.IndividualList;
import freak.core.searchspace.HasMetric;

public class DistanceFromOptimum
extends AbstractObserver
implements IndividualListEventListener,
Configurable {
    public DistanceFromOptimum(Schedule schedule) {
        super(schedule);
        this.setMeasure(1);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        try {
            schedule.getFitnessFunction().getGenotypeOptimum();
        }
        catch (UnsupportedOperationException e) {
            throw new UnsupportedEnvironmentException("Global optimum is unknown.");
        }
        if (!(schedule.getGenotypeSearchSpace() instanceof HasMetric)) {
            throw new UnsupportedEnvironmentException("Search space has no metric.");
        }
    }

    public Class getOutputDataType() {
        return double[].class;
    }

    public String getName() {
        return "Distance from Optimum";
    }

    public String getDescription() {
        return "Computes the individuals' distance to the global optimum.";
    }

    public void individualList(IndividualListEvent evt) {
        IndividualList individualList = evt.getIndividualList();
        Individual[] individuals = individualList.toArray();
        double[] distance = new double[individualList.size()];
        HasMetric searchSpace = (HasMetric)((Object)this.getSchedule().getGenotypeSearchSpace());
        Genotype optimum = this.getSchedule().getFitnessFunction().getGenotypeOptimum();
        int i = 0;
        while (i < individuals.length) {
            distance[i] = searchSpace.getDistance(individuals[i].getGenotype(), optimum);
            ++i;
        }
        this.updateViews(distance);
    }

    public void createEvents() {
        super.createEvents();
        this.getSchedule().getEventController().addEvent(this, "Get individuals from", IndividualListEvent.class, this.getSchedule().getPopulationManager());
    }
}

