/*
 * Decompiled with CFR 0.152.
 */
package freak.module.observer;

import freak.core.control.Schedule;
import freak.core.event.IndividualListEvent;
import freak.core.event.IndividualListEventListener;
import freak.core.fitness.SingleObjectiveFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.modulesupport.UnsupportedEnvironmentException;
import freak.core.observer.AbstractObserver;
import freak.core.population.Individual;
import freak.core.population.IndividualList;

public class CurrentFitness
extends AbstractObserver
implements IndividualListEventListener,
Configurable {
    public CurrentFitness(Schedule schedule) {
        super(schedule);
        this.setMeasure(1);
    }

    public void testSchedule(Schedule schedule) throws UnsupportedEnvironmentException {
        super.testSchedule(schedule);
        if (!(schedule.getFitnessFunction() instanceof SingleObjectiveFitnessFunction)) {
            throw new UnsupportedEnvironmentException("This module works on single objective fitness functions only.");
        }
    }

    public Class getOutputDataType() {
        return double[].class;
    }

    public String getName() {
        return "Current Fitness";
    }

    public String getDescription() {
        return "Computes the fitness values of the observed individuals.";
    }

    public void individualList(IndividualListEvent evt) {
        IndividualList individualList = evt.getIndividualList();
        Individual[] individuals = individualList.toArray();
        double[] fitnessValues = new double[individuals.length];
        int i = 0;
        while (i < individuals.length) {
            fitnessValues[i] = ((SingleObjectiveFitnessFunction)this.getSchedule().getFitnessFunction()).evaluate(individuals[i], individualList);
            ++i;
        }
        this.updateViews(fitnessValues);
    }

    public void createEvents() {
        super.createEvents();
        this.getSchedule().getEventController().addEvent(this, "Get individuals from", IndividualListEvent.class, this.getSchedule().getPopulationManager());
    }
}

