/*
 * Decompiled with CFR 0.152.
 */
package freak.module.fitness.pointset;

import freak.core.control.Schedule;
import freak.core.fitness.AbstractFitnessFunction;
import freak.core.modulesupport.Configurable;
import freak.core.population.Genotype;
import freak.module.fitness.pointset.WrongNumberOfPointsException;
import freak.module.fitness.pointset.util.ResidualContainer;
import freak.module.fitness.pointset.util.ResidualHyperPlane;
import freak.module.searchspace.PointSet;
import freak.module.searchspace.PointSetGenotype;
import java.util.Arrays;

public abstract class AbstractRobustRegressionFitness
extends AbstractFitnessFunction
implements Configurable {
    protected int[] chosenIndices = null;
    private double[] fittedHyperplane = null;
    protected int offset = -5000;
    protected String m_zName = "LXX";
    protected String m_zInstanceName = "";
    protected int h;
    protected ResidualHyperPlane hyperPlane = new ResidualHyperPlane();
    protected boolean interceptAdjust = false;
    public ResidualContainer[] m_hResiduals = null;

    public AbstractRobustRegressionFitness(Schedule schedule) {
        super(schedule);
        if (schedule.getPhenotypeSearchSpace() instanceof PointSet) {
            PointSet ps = (PointSet)schedule.getPhenotypeSearchSpace();
            this.h = this.computeH(ps.getDimension(), ps.getPointDimension());
        }
    }

    public ResidualHyperPlane getResidualHyperPlane() {
        return this.hyperPlane;
    }

    public ResidualContainer[] getResiduals() {
        return this.m_hResiduals;
    }

    protected void rememberChoosenParameters() {
        int dim = this.hyperPlane.getParameter().getDimension();
        this.fittedHyperplane = new double[dim];
        int i = 0;
        while (i < dim) {
            try {
                this.fittedHyperplane[i] = this.hyperPlane.getParameter().get(i);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ++i;
        }
        this.chosenIndices = new int[this.h];
        i = 0;
        while (i < this.h) {
            this.chosenIndices[i] = this.m_hResiduals[i].pointIndexInPointSet;
            ++i;
        }
    }

    protected abstract double evaluateResiduals();

    protected int computeH(int dimension, int pointDimension) {
        double alpha = 0.5;
        return (int)(2.0 * (double)((int)((double)(dimension + pointDimension + 1) / 2.0)) - (double)dimension + 2.0 * alpha * ((double)dimension - (double)((int)((double)(dimension + pointDimension + 1) / 2.0))));
    }

    protected void adjustHyperplane(Genotype genotype) {
        Arrays.sort(this.m_hResiduals);
        this.hyperPlane.computeParamLS(((PointSetGenotype)genotype).getPoints(), this.m_hResiduals, this.h);
    }

    protected void calculateResiduals(Genotype genotype) throws WrongNumberOfPointsException {
        PointSet.Point[] supportPoints = ((PointSetGenotype)genotype).getChoosenSubSet();
        PointSet.Point[] allPoints = ((PointSetGenotype)genotype).getPoints();
        int pointDim = ((PointSetGenotype)genotype).getPointDimension();
        int quantile = this.h;
        if (supportPoints.length == 0) {
            throw new WrongNumberOfPointsException(-pointDim);
        }
        if (supportPoints.length != supportPoints[0].getDimension()) {
            throw new WrongNumberOfPointsException(-(supportPoints.length - pointDim));
        }
        this.hyperPlane.computeParam(supportPoints);
        this.m_hResiduals = new ResidualContainer[allPoints.length];
        this.hyperPlane.updateResiduals(this.m_hResiduals, allPoints);
    }

    public double[] getFittedHyperplane() {
        return this.fittedHyperplane;
    }

    public String getName() {
        return String.valueOf(this.m_zName) + (!this.m_zInstanceName.equals("") ? ": " + this.m_zInstanceName : "");
    }

    public Genotype getPhenotypeOptimum() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    public String getShortDescriptionForH() {
        return "h";
    }

    public String getLongDescriptionForH() {
        return "Size of the subset of points.";
    }

    public Integer getPropertyH() {
        return new Integer(this.h);
    }

    public void setPropertyH(Integer H) {
        if (H > 0) {
            this.h = H;
        }
    }

    public int[] getChosenIndices() {
        return this.chosenIndices;
    }
}

