/*
 * Decompiled with CFR 0.152.
 */
package freak.core.control;

import freak.core.control.BatchProcessor;
import freak.core.modulesupport.PersistenceManager;
import freak.gui.JButtonFactory;
import freak.gui.runframe.AbstractRunFrame;
import freak.gui.runframe.RunFrame;
import jargs.gnu.CmdLineParser;
import java.awt.Toolkit;
import java.io.File;
import java.util.Locale;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class Freak {
    private static int actionModifierKey;
    private static int DEBUG_LEVEL;
    static AbstractRunFrame f;

    static {
        DEBUG_LEVEL = 0;
    }

    public static void viewFilenameInTitle(String s) {
        if (f != null) {
            f.viewFilenameInTitle(s);
        }
    }

    public static void main(String[] arguments) throws Exception {
        File loadFile = null;
        File saveFile = null;
        File[] tempFiles = null;
        CmdLineParser parser = new CmdLineParser();
        CmdLineParser.Option fileOption = parser.addStringOption('f', "temp-file-base");
        CmdLineParser.Option intervalOption = parser.addIntegerOption('i', "temp-file-interval");
        CmdLineParser.Option debugOption = parser.addIntegerOption('d', "debug-level");
        try {
            parser.parse(arguments);
        }
        catch (CmdLineParser.IllegalOptionValueException e) {
            Freak.printUsage();
            return;
        }
        catch (CmdLineParser.UnknownOptionException e) {
            Freak.printUsage();
            return;
        }
        String tempFileBase = (String)parser.getOptionValue(fileOption);
        if (tempFileBase != null) {
            File tempFile1 = new File(String.valueOf(tempFileBase) + "1.freak");
            File tempFile2 = new File(String.valueOf(tempFileBase) + "2.freak");
            tempFiles = new File[]{tempFile1, tempFile2};
        }
        DEBUG_LEVEL = parser.getOptionValue(debugOption) != null ? (Integer)parser.getOptionValue(debugOption) : 0;
        long interval = 1000 * (parser.getOptionValue(debugOption) != null ? (Integer)parser.getOptionValue(intervalOption) : 3600);
        arguments = parser.getRemainingArgs();
        if (arguments.length > 0) {
            loadFile = new File(arguments[0]);
        }
        if (arguments.length > 1) {
            saveFile = new File(arguments[1]);
        }
        if (arguments.length > 2) {
            Freak.printUsage();
            return;
        }
        Locale.setDefault(Locale.US);
        PersistenceManager.init();
        if (loadFile == null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    try {
                        String lookAndFeel = UIManager.getLookAndFeel().getName();
                        actionModifierKey = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                        if (lookAndFeel.equals("Mac OS X Aqua")) {
                            JButtonFactory.activateBugFix();
                        }
                        f = new RunFrame();
                        f.setLocationRelativeTo(null);
                        f.setVisible(true);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            });
        } else {
            BatchProcessor batchProcessor = new BatchProcessor(loadFile, saveFile, tempFiles, interval);
            batchProcessor.run();
        }
    }

    private static void printUsage() {
        System.out.println("freak [options]\nfreak [options] loadSchedule\nfreak [options] loadSchedule saveSchedule\n\nOptions:\n  -d, --debug-level:           verbosity; default = 4  -f, --temp-file-base:        start of file name for backup files  -i, --temp-file-interval:    backup interval in seconds; default = 3600");
    }

    public static int getActionModifierKey() {
        return actionModifierKey;
    }

    public static void debug(String message, int level) {
        if (level <= DEBUG_LEVEL) {
            System.out.println(message);
        }
    }

    public static void setDebugLevel(int debug_level) {
        DEBUG_LEVEL = debug_level;
    }
}

