% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dplyr_integration.R
\name{backend_dbplyr_v2}
\alias{backend_dbplyr_v2}
\alias{sql_query_explain.AthenaConnection}
\alias{sql_query_fields.AthenaConnection}
\alias{sql_escape_date.AthenaConnection}
\alias{sql_escape_datetime.AthenaConnection}
\title{Athena S3 implementation of dbplyr backend functions (api version 2).}
\usage{
sql_query_explain.AthenaConnection(con, sql, format = "text", type = NULL, ...)

sql_query_fields.AthenaConnection(con, sql, ...)

sql_escape_date.AthenaConnection(con, x)

sql_escape_datetime.AthenaConnection(con, x)
}
\arguments{
\item{con}{A \code{\link{dbConnect}} object, as returned by \code{dbConnect()}}

\item{sql}{SQL code to be sent to AWS Athena}

\item{format}{returning format for explain queries, default set to `"text"`. Other formats can be found: \url{https://docs.aws.amazon.com/athena/latest/ug/athena-explain-statement.html}}

\item{type}{return plan for explain queries, default set to `NULL`. Other type can be found: \url{https://docs.aws.amazon.com/athena/latest/ug/athena-explain-statement.html}}

\item{...}{other parameters, currently not implemented}

\item{x}{R object to be transformed into athena equivalent}
}
\value{
\describe{
\item{sql_query_explain}{Returns sql query for \href{https://docs.aws.amazon.com/athena/latest/ug/athena-explain-statement.html}{AWS Athena explain statement}}
\item{sql_query_fields}{Returns sql query column names}
\item{sql_escape_date}{Returns sql escaping from dates}
\item{sql_escape_datetime}{Returns sql escaping from date times}
}
}
\description{
These functions are used to build the different types of SQL queries. 
The AWS Athena implementation give extra parameters to allow access the to standard DBI Athena methods. They also
utilise AWS Glue to speed up sql query execution.
}
