% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_low_api.R
\name{assume_role}
\alias{assume_role}
\title{Assume AWS ARN Role}
\usage{
assume_role(
  profile_name = NULL,
  region_name = NULL,
  role_arn = NULL,
  role_session_name = sprintf("RAthena-session-\%s", as.integer(Sys.time())),
  duration_seconds = 3600L,
  set_env = FALSE
)
}
\arguments{
\item{profile_name}{The name of a profile to use. If not given, then the default profile is used.
To set profile name, the \href{https://aws.amazon.com/cli/}{AWS Command Line Interface} (AWS CLI) will need to be configured.
To configure AWS CLI please refer to: \href{https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html}{Configuring the AWS CLI}.}

\item{region_name}{Default region when creating new connections. Please refer to \href{https://docs.aws.amazon.com/general/latest/gr/rande.html}{link} for 
AWS region codes (region code example: Region = EU (Ireland)     \code{ region_name = "eu-west-1"})}

\item{role_arn}{The Amazon Resource Name (ARN) of the role to assume (such as \code{arn:aws:sts::123456789012:assumed-role/role_name/role_session_name})}

\item{role_session_name}{An identifier for the assumed role session. By default `RAthena` creates a session name \code{sprintf("RAthena-session-\%s", as.integer(Sys.time()))}}

\item{duration_seconds}{The duration, in seconds, of the role session. The value can range from 900 seconds (15 minutes) up to the maximum session duration setting for the role.
This setting can have a value from 1 hour to 12 hours. By default duration is set to 3600 seconds (1 hour).}

\item{set_env}{If set to \code{TRUE} environmental variables \code{AWS_ACCESS_KEY_ID}, \code{AWS_SECRET_ACCESS_KEY} and \code{AWS_SESSION_TOKEN} will be set.}
}
\value{
\code{assume_role()} returns a list containing: \code{"AccessKeyId"}, \code{"SecretAccessKey"}, \code{"SessionToken"} and \code{"Expiration"}
}
\description{
Returns a set of temporary security credentials that you can use to access AWS resources that you might not normally have access to (\href{https://boto3.amazonaws.com/v1/documentation/api/latest/reference/services/sts.html#STS.Client.assume_role}{link}).
These temporary credentials consist of an access key ID, a secret access key, and a security token. Typically, you use AssumeRole within
your account or for cross-account access.
}
\examples{
\dontrun{
# Note: 
# - Require AWS Account to run below example.

library(RAthena)
library(DBI)

# Assuming demo ARN role
assume_role(profile_name = "YOUR_PROFILE_NAME",
            role_arn = "arn:aws:sts::123456789012:assumed-role/role_name/role_session_name",
            set_env = TRUE)
            
# Connect to Athena using ARN Role
con <- dbConnect(RAthena::athena())
}
}
\seealso{
\code{\link{dbConnect}}
}
