% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ltx_plot.r
\name{ltx_plot}
\alias{ltx_plot}
\title{Prints a R plot to a latex file or console}
\usage{
ltx_plot(
  plot,
  out,
  title = "plot",
  titlepr = NULL,
  footnote = "",
  plotnote = "",
  lwidth = NULL,
  pwidth = 10,
  pheight = 5.5,
  res = NULL,
  hyper = TRUE,
  outfmt = "pdf",
  fontsize = 12,
  units = "px",
  rawout = paste0(out, ".rawtex"),
  linebreak = TRUE,
  label = NULL,
  captpl = "top",
  rotate = FALSE,
  cleancur = FALSE,
  ...
)
}
\arguments{
\item{plot}{plot object or function call that creates plot to be printed to file}

\item{out}{filename for the output latex file}

\item{title}{character string to define the title of the plot which will be added to the caption}

\item{titlepr}{character string to define the prefix of the title. Can be used to create custom numbering}

\item{footnote}{character string with the footnote to be placed in the footer of the page (LaTeX coding can be used for example to create line breaks)}

\item{plotnote}{character string with the plot note to be placed directly below the plot (LaTeX coding can be used for example to create line breaks)}

\item{lwidth}{character string indicating the width of the plot within latex (e.g. "\\\\linewidth")}

\item{pwidth}{numeric indicating the width of the plot to be generated in inches or pixels (for respectively the extensions pdf and png)}

\item{pheight}{numeric indicating the height of the plot to be generated in inches or pixels (for respectively the extensions pdf and png)}

\item{res}{numeric indicating the resolution of the plot (in case png is used), if set to NULL it will adapt the value according height of the plot}

\item{hyper}{logical indicating if a hypertarget should be set used for bookmarks}

\item{outfmt}{character string indicating the format of the output file (currently "pdf" and "png" are accepted)}

\item{fontsize}{character string with the default font or pointsize passed through to png or pdf function}

\item{units}{character string with the units to use for plot width and height passed through to png function}

\item{rawout}{character string with the name of the raw latex file to generate (e.g. only plot code with no preamble and document ending)
In case NULL no raw output will be generated. In order to combine results the filename should end in .rawtex}

\item{linebreak}{logical indicating if a linebreak (clearpage) should be given after a plot}

\item{label}{character with the label to add after the caption for referencing the table in text}

\item{captpl}{character with the caption placement, can be either "top" or "bottom"}

\item{rotate}{logical indicating if the resulting figure should be rotated 90 degrees clockwise}

\item{cleancur}{logical indicating if the available plots should be deleted before creating new ones}

\item{...}{additional arguments passed through to \code{\link{ltx_doc}}. Most important are template, rendlist, compile and show}
}
\value{
The function returns a latex file (or writes output to console)
}
\description{
This function makes a latex document including the plots defined
}
\examples{

# It is convenient to have an object for the plot argument
\dontrun{
  data(Theoph)
  library(ggplot2)
  pl <- qplot(Time, conc, data=Theoph, facets=~Subject,geom="line")
  ltx_plot(pl,out=tempfile(fileext=".tex"))

  # Base plots work a bit different and can be placed
  # in the function directly or wrapped in a function
  pl <- function() {
    plot(conc~Time,data=Theoph)
    title(main="a plot")
  }
  ltx_plot(pl(),out=tempfile(fileext=".tex"))
  # In case of big data it can be more convenient to have a png included
  ltx_plot(plot(rnorm(1e6)),out=tempfile(fileext=".tex"),
           outfmt="png",pwidth=2000,pheight=1200)
}
}
