% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html_list.r
\name{html_list}
\alias{html_list}
\title{Creates a HTML listing}
\usage{
html_list(
  dfrm,
  vars = names(dfrm),
  fill = "",
  vargroup = NULL,
  porder = TRUE,
  uselabel = TRUE,
  footnote = NULL,
  title = "listing",
  titlepr = NULL,
  group = NULL,
  xrepeat = FALSE,
  tclass = "sample",
  out = NULL,
  rawout = paste0(out, ".rawhtml"),
  ...
)
}
\arguments{
\item{dfrm}{data frame to be listed}

\item{vars}{character vector that defines the variables within the data frame to be placed in the table}

\item{fill}{character indicating the character to use in case of missing values}

\item{vargroup}{character vector of the same length as vars. Creates a first line in the table to group variables (see details)}

\item{porder}{logical indicating if the data frame should be ordered on the variables given in vars}

\item{uselabel}{logical indicating if labels should be used for the variable(s).
If set to TRUE, the function will try to use the label attribute for the display of variable(s).}

\item{footnote}{character string with the footnote to be placed in the footer of the page (HTML coding can be used for example to create line breaks)}

\item{title}{character string to define the title of the output which will be added to the caption}

\item{titlepr}{character string to define the prefix of the output title. Can be used to create custom table numbering}

\item{group}{numeric indicating the last index of the used variables that should be grouped (displayed in table with a certain white space), interpreted as x[1:group]}

\item{xrepeat}{logical indicating if duplicate x values should be repeated in the table or not}

\item{tclass}{character string with the table class. Can be used in combination with custom css}

\item{out}{filename for the output HTML file (if NULL it will print to console)}

\item{rawout}{character string with the name of the raw HTML file to generate (e.g. only table)
In case NULL no raw output will be generated. In order to combine results the filename should end in .rawhtml}

\item{...}{additional arguments passed through to \code{\link{html_doc}}. Most important are template, rendlist, css and show}
}
\value{
The function returns a HTML file (or writes output to console)
}
\description{
This function creates a HTML listing which can be written to a file or console
}
\details{
The vargroup argument should be provided in the following form: \cr
  \code{c(rep("",4),rep("group1",3),rep("group2",4))}.
  The function will place the text within the vector with the given length as first line in the table with a midrule below it.
  an exception is made for empty strings. The format of the current listing/css was designed to look good in the browser and in a WORD
  document (when html is opened in WORD). Additional colspans are added in the table header which might lead to additional space in case
  a user defined css file is used.
}
\examples{

# an example how vargroup can be used
grp <- c(rep("",3),rep("grouped variables",2))
\dontrun{
  data(Theoph)
  html_list(Theoph,out=tempfile(fileext=".html"))
  html_list(Theoph,out=tempfile(fileext=".html"),vargroup=grp)
}
}
