% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terms.R
\name{term_freq}
\alias{term_freq}
\title{term_freq}
\usage{
term_freq(dtm, terms, variable = NULL, by_term = FALSE)
}
\arguments{
\item{dtm}{A \code{DocumentTermMatrix}.}

\item{terms}{One or more reference term(s) appearing in \code{dtm}.}

\item{variable}{An optional vector of values giving the groups for which most frequent
terms should be reported.}

\item{by_term}{Whether the third dimension of the array should be terms instead of levels.}
}
\value{
A list of matrices, one for each level of the variable, with columns:
\itemize{
\item "\% Term/Level": the percent of the term's occurrences in all terms occurrences
in documents where the chosen term is also present.
\item "\% Level/Term": the percent of the term's occurrences that appear in documents
where the chosen term is also present (rather than in documents where it does not appear),
i.e. the percent of cooccurrences for the term..
\item "Global \%": the percent of the term's occurrences in all terms occurrences
in the corpus (or in the subset of the corpus corresponding to the variable level).
\item "Level": the number of cooccurrences of the term.
\item "Global": the number of occurrences of the term in the corpus
(or in the subset of the corpus corresponding to the variable level).
\item "t value": the quantile of a normal distribution corresponding the probability "Prob.".
\item "Prob.": the probability of observing such an extreme (high or low) number of occurrences of
the term in documents where the chosen term is also present, under an hypergeometric distribution.
}
}
\description{
Study frequencies of chosen terms in the corpus, among documents, or among levels of
}
\examples{

file <- system.file("texts", "reut21578-factiva.xml", package="tm.plugin.factiva")
corpus <- import_corpus(file, "factiva", language="en")
dtm <- build_dtm(corpus)
term_freq(dtm, "barrel")
term_freq(dtm, "barrel", meta(corpus)$Date)

}
