#' Determinants of the Arab Spring uprising
#'
#' A dataset containing fuzzy-set membership scores for ten sets of state
#' characteristics (per-capita GDP, economic inequality, etc.) across 20
#' states in northern Africa and the Arab Peninsula at the time of the
#' Arab Spring uprisings of 2010-12.
#'
#' @format A data frame with 20 rows and 10 variables, measured as fuzzy set
#' membership scores.
#' \itemize{
#'   \item{Gdppc: per-capita GDP}
#'   \item{Gini: economic inequality}
#'   \item{Unemp: unemployment}
#'   \item{Urban: degree of urbanization}
#'   \item{Youth: size of youth bulge}
#'   \item{Mobile: mobile phone usage}
#'   \item{Internet: internet penetration}
#'   \item{Fuel: fuel-dependence of economy}
#'   \item{Pol: regime fragility}
#'   \item{Success: social movement success}
#' }
#' @source Hussain, Muzammil M., and Philip N. Howard. 2013. "What Best Explains Successful Protest Cascades? ICTs and the Fuzzy Causes of the Arab Spring." International Studies Review 15(1): 48-66, Table 1. Data archived at \url{http://philhoward.org/wp-content/uploads/2012/11/International-Studies-Review-Replication-Data.csv}
"Arab.Spring"