% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weighting.R
\name{weight_by_regime}
\alias{weight_by_regime}
\title{Regime-Based Adaptive Weighting}
\usage{
weight_by_regime(
  selected_df,
  regime,
  weighting_configs,
  signal_df = NULL,
  vol_timeframe_data = NULL,
  strategy_timeframe_data = NULL
)
}
\arguments{
\item{selected_df}{Binary selection matrix (1 = selected, 0 = not)}

\item{regime}{Regime classification (integer values per period)}

\item{weighting_configs}{List with method-specific parameters}

\item{signal_df}{Signal values (required for signal/rank methods)}

\item{vol_timeframe_data}{Volatility data (required for volatility method)}

\item{strategy_timeframe_data}{Strategy timeframe alignment data}
}
\value{
Data.table with regime-adaptive weights
}
\description{
Applies different weighting methods based on market regime classification.
Enables adaptive strategies that change allocation approach in different
market conditions.
}
\examples{
data("sample_prices_weekly")
# Create selection and signals
momentum <- calc_momentum(sample_prices_weekly, lookback = 12)
selected <- filter_top_n(momentum, n = 10)

# Create a simple regime (example: based on market trend)
ma20 <- calc_moving_average(sample_prices_weekly, 20)
spy_price <- sample_prices_weekly$SPY
spy_ma <- ma20$SPY
regime <- ifelse(spy_price > spy_ma, 1, 2)

# Different weights for bull/bear markets
weighting_configs <- list(
  "1" = list(method = "equal"),
  "2" = list(method = "signal")
)
weights <- weight_by_regime(selected, regime, weighting_configs,
                            signal_df = momentum)
}
