% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimateEM.R
\name{format_output}
\alias{format_output}
\title{Run the EM for several values of K}
\usage{
format_output(results_estim_EM, phylo, time = NA)
}
\arguments{
\item{results_estim_EM}{output of function \code{estimateEM}}

\item{time}{to run the function}
}
\value{
summary a data frame with K_max lines, and columns:
   - alpha_estim the estimated selection strength
   - gamma_estim the estimated root variance
   - beta_0_estim the estimated value of root optumum
   - EM_steps number of iterations needed before convergence
   - DV_estim has the EM diverged ?
   - CV_estim has the EM converged ?
   - log_likelihood log likelihood of the data using the estimated parameters
   - mahalanobis_distance_data_mean the mahalanobis distance between the data
and the estimated means at the tips
   - least_squares the mahalanobis distance, renormalized by gamma^2: 
mahalanobis_distance_data_mean * gamma_estim.
   - mean_number_new_shifts the mean number of shifts that changed over the 
iterations of the EM
   - number_equivalent_solutions the number of equivalent solutions to 
the solution found.
   - K_try the number of shifts allowed.
   - complexity the complexity for K_try
   - time the CPU time needed.

params a list of infered parameters

params_init a list of initial paramters

alpha_0 initial values of alpha

gmma_0 initial values of gamma

Zhat reconstructed node states

m_Y_estim reconstructed tip states

edge.quality for each edge, relative number of iterations in which they
 were present.
}
\description{
\code{estimateEM_several_K.OUsr} uses function \code{estimateEM} on the data, 
for all values of K between 0 and K_max.
}
\details{
The EM is fisrt launched for K=0, with alpha and gamma estimated. The
estimated values of alpha, gamma and beta_0 found by this fisrt EM are then
used as initialisation parameters for all the other runs of the EM for other
K.
The EMs are parralelized thanks to packages \code{foreach} and 
\code{doParallel}.
WARNING : this code only work of OU with stationary root, on an ultrametric
tree.
}
\keyword{internal}

