% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohortDiagnostics.R
\name{cohortDiagnostics}
\alias{cohortDiagnostics}
\title{Run cohort-level diagnostics}
\usage{
cohortDiagnostics(cohort)
}
\arguments{
\item{cohort}{Cohort table in a cdm reference}
}
\value{
A summarised result
}
\description{
Runs phenotypeR diagnostics on the cohort.
The diganostics include:
* Age groups and sex summarised.
* A summary of visits of everyone in the cohort using visit_occurrence table.
* A summary of age and sex density of the cohort.
* Attritions of the cohorts.
* Overlap between cohorts (if more than one cohort is being used).
}
\examples{
\donttest{
cdm_local <- omock::mockCdmReference() |>
  omock::mockPerson(nPerson = 100) |>
  omock::mockObservationPeriod() |>
  omock::mockConditionOccurrence() |>
  omock::mockDrugExposure() |>
  omock::mockObservation() |>
  omock::mockMeasurement() |>
  omock::mockVisitOccurrence() |>
  omock::mockProcedureOccurrence() |>
  omock::mockCohort(name = "my_cohort")
 db <- DBI::dbConnect(duckdb::duckdb())
 cdm <- CDMConnector::copyCdmTo(con = db,
                                cdm = cdm_local,
                                schema ="main",
                                overwrite = TRUE)

 cdm$my_cohort |> cohortDiagnostics()
 CDMConnector::cdmDisconnect(cdm = cdm)
}
}
