% Generated by roxygen2 (4.0.2): do not edit by hand
\name{dfRowsToList}
\alias{dfRowToList}
\alias{dfRowsToList}
\title{Convert a data.frame row to list of parameter-value-lists.}
\usage{
dfRowsToList(df, par.set)

dfRowToList(df, par.set, i)
}
\arguments{
\item{df}{[\code{data.frame}]\cr
Data.frame, potentially from \code{\link{OptPathDF}}.
Columns are assumed to be in the same order as par.set.}

\item{par.set}{[\code{\link{ParamSet}}]\cr
Parameter set.}

\item{i}{[\code{integer(1)}]\cr
Row index.}
}
\value{
[\code{list}]. Named by parameter ids.
}
\description{
Please note that (naturally) the columns of \code{df} have to be of the correct type
type w.r.t. the corresponding parameter. The only exception are integer parameters
where the corresponding columns in \code{df} are allowed to be numerics.

\tabular{ll}{
 numeric(vector)   \tab  \code{numeric}  \cr
 integer(vector)   \tab  \code{integer}  \cr
 discrete(vector)  \tab  \code{factor} (names of values = levels) \cr
 logical(vector)   \tab  \code{logical}
}

Dependent parameters whose requirements are not satisfied are represented by a scalar
NA in the output.
}

