% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrcc_qualityControl.R
\name{wrcc_qualityControl}
\alias{wrcc_qualityControl}
\title{Apply Quality Control to raw WRCC tibble}
\usage{
wrcc_qualityControl(tbl, ...)
}
\arguments{
\item{tbl}{single site tibble created by \code{wrcc_downloadData()}}

\item{...}{additional parameters are passed to type-specific QC functions}
}
\value{
Cleaned up tibble of WRCC monitor data.
}
\description{
Various QC steps are taken to clean up the incoming raw tibble including:

\enumerate{
\item{Convert numeric missing value flags to \code{NA}.}
\item{Remove measurement records with values outside of valid ranges.}
}

See the individual \code{wrcc_~QualityControl()} functions for details.
}
\seealso{
\code{\link{wrcc_EBAMQualityControl}}

\code{\link{wrcc_ESAMQualityControl}}
}
\keyword{WRCC}
