% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_performanceMap.R
\name{monitor_performanceMap}
\alias{monitor_performanceMap}
\title{Create map of monitor prediction performance}
\usage{
monitor_performanceMap(
  predicted,
  observed,
  threshold = AQI$breaks_24[3],
  cex = par("cex"),
  sizeBy = NULL,
  colorBy = "heidikeSkill",
  breaks = c(-Inf, 0.5, 0.6, 0.7, 0.8, Inf),
  paletteFunc = grDevices::colorRampPalette(RColorBrewer::brewer.pal(length(breaks),
    "Purples")[-1]),
  showLegend = TRUE,
  legendPos = "topright",
  stateCol = "grey60",
  stateLwd = 2,
  countyCol = "grey70",
  countyLwd = 1,
  add = FALSE,
  ...
)
}
\arguments{
\item{predicted}{ws_monitor object with predicted values}

\item{observed}{ws_monitor object with observed  values}

\item{threshold}{value used to classify \code{predicted} and \code{observed}
measurements}

\item{cex}{the amount that the points will be magnified on the map}

\item{sizeBy}{name of the metric used to create relative sizing}

\item{colorBy}{name of the metric used to create relative colors}

\item{breaks}{set of breaks used to assign colors or a single integer used to
provide quantile based breaks - Must also specify the colorBy paramater}

\item{paletteFunc}{a palette generating function as returned by
\code{colorRampPalette}}

\item{showLegend}{logical specifying whether to add a legend (default:
\code{TRUE})}

\item{legendPos}{legend position passed to \code{legend()}}

\item{stateCol}{color for state outlines on the map}

\item{stateLwd}{width for state outlines}

\item{countyCol}{color for county outline on the map}

\item{countyLwd}{width for county outlines}

\item{add}{logical specifying whether to add to the current plot}

\item{...}{additional arguments to be passed to the \code{maps::map()}
funciton such as graphical parameters (see code{?par})}
}
\description{
This function uses \emph{confusion matrix} analysis to calculate different
measures of predictive performance for every timeseries found in
\code{predicted} with respect to the observed values found in the single
timeseries found in \code{observed}.

Using a single number for the \code{breaks} argument will cause the algorithm
to use quantiles to determine breaks.
}
\details{
Setting either \code{sizeBy} or \code{colorBy} to \code{NULL} will cause the
size/colors to remain constant.
}
\examples{
\dontrun{
library(PWFSLSmoke)

# Napa Fires -- October, 2017
ca <- airnow_load(2017) \%>\%
  monitor_subset(tlim=c(20171001,20171101), stateCodes='CA')
Vallejo <- monitor_subset(ca, monitorIDs='060950004_01')
Napa_Fires <- monitor_subsetByDistance(ca,
                                       longitude = Vallejo$meta$longitude,
                                       latitude = Vallejo$meta$latitude,
                                       radius = 50)
monitor_performanceMap(ca, Vallejo, cex = 2)
title('Heidke Skill of monitors predicting another monitor.')
}
}
\seealso{
\link{monitor_performance}
}
\keyword{ws_monitor}
