% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_load.R
\name{monitor_load}
\alias{monitor_load}
\title{Load PM2.5 monitoring data}
\usage{
monitor_load(
  startdate = NULL,
  enddate = NULL,
  monitorIDs = NULL,
  parameter = "PM2.5",
  baseUrl = "https://haze.airfire.org/monitoring",
  dataDir = NULL,
  aqsPreference = "airnow"
)
}
\arguments{
\item{startdate}{Desired start date (integer or character in ymd[hms] format
or \code{POSIXct}).}

\item{enddate}{Desired end date (integer or character in ymd[hms] format
or \code{POSIXct}).}

\item{monitorIDs}{Optional vector of monitorIDs.}

\item{parameter}{Parameter of interest.}

\item{baseUrl}{Base URL for data files.}

\item{dataDir}{Local directory containing monitoring data files.}

\item{aqsPreference}{Preferred data source for AQS data when annual data
files are available from both `epa` and `airnow`.}
}
\value{
A \emph{ws_monitor} object with PM2.5 monitoring data.
}
\description{
Loads monitoring data for a given time range. Data from AirNow,
AIRSIS and WRCC are combined into a single \emph{ws_monitor} object.

Archival datasets are joined with 'daily' and 'latest' datasets as needed to
satisfy the requested date range.
}
\note{
Joining datasets is a computationally expensive task when many monitors
are involved. It is highly recommend that \code{monitorIDs} be specified when
loading recent data with this function.
}
\examples{
\dontrun{
ca <- monitor_load(20170601,20171001) \%>\% monitor_subset(stateCodes='CA')
}
}
\seealso{
\code{\link{loadDaily}}

\code{\link{loadLatest}}
}
\keyword{AIRSIS}
\keyword{AirNow}
\keyword{WRCC}
