% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createEmptyMetaDataframe.R
\name{createEmptyMetaDataframe}
\alias{createEmptyMetaDataframe}
\title{Create Empty Site Location Metadata Dataframe}
\usage{
createEmptyMetaDataframe(rows = 0)
}
\arguments{
\item{rows}{number of rows}
}
\value{
A empty \code{meta} dataframe for use in a \emph{ws_monitor} object.
}
\description{
The list of columns in the returned \code{meta} dataframe is:

\preformatted{
> names(meta)
 [1] "monitorID"             "longitude"             "latitude"             
 [4] "elevation"             "timezone"              "countryCode"          
 [7] "stateCode"             "siteName"              "agencyName"           
[10] "countyName"            "msaName"               "monitorType"          
[13] "monitorInstrument"     "aqsID"                 "pwfslID"              
[16] "pwfslDataIngestSource" "telemetryAggregator"   "telemetryUnitID"      
}

For each row, all values will be set to \code{NA} with the appropriate type,
either \code{numeric} or \code{character}.

An empty dataframe can be generated by setting \code{rows=0}.
}
\examples{
meta_3 <- createEmptyMetaDataframe(rows=3)
all(is.na(meta_3))
}
\keyword{internal}
