% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_subsetBy.R
\name{monitor_subsetBy}
\alias{monitor_subsetBy}
\title{Subset ws_monitor Object with a Filter}
\usage{
monitor_subsetBy(ws_monitor, filter)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object}

\item{filter}{a filter to use on the ws_monitor object}
}
\value{
A \emph{ws_monitor} object with a subset of the input ws_monitor object.
}
\description{
The incoming ws_monitor object is filtered according to \code{filter}.
Either meta data or actual data can be filtered.
}
\examples{
N_M <- Northwest_Megafires
boise_tz <- monitor_subsetBy(N_M, timezone == 'America/Boise')
boise_tz_very_unhealthy <- monitor_subsetBy(boise_tz, data > AQI$breaks_24[5])
boise_tz_very_unhealthy$meta$siteName
}
\keyword{ws_monitor}
