% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Grey_PSSM_PseAAC.R
\name{grey_pssm_pseAAC}
\alias{grey_pssm_pseAAC}
\title{grey pssm feature vector}
\usage{
grey_pssm_pseAAC(pssm_name)
}
\arguments{
\item{pssm_name}{name of PSSM matrix file}
}
\value{
feature vector of length 100
}
\description{
This function produces a feature vector of length 100 which the first 20 components of this
vector is the normalized occurrence frequency of the native amino acids in the  protein. the next 20
components are mean of 20 PSSM columns and grey system model approach as elaborated in (Min et al. 2013)
is used to define the next 60 components.
}
\examples{
as<-grey_pssm_pseAAC(system.file("extdata", "C7GQS7.txt.pssm", package="PSSMCOOL"))
}
\references{
J.-L. Min, X. Xiao, and K.-C. J. B. r. i. Chou, "iEzy-Drug: A web server for identifying the interaction
between enzymes and drugs in cellular networking," vol. 2013, 2013.

X. Xiao, M. Hui, and Z. J. T. J. o. m. b. Liu, "IAFP-Ense: an ensemble classifier for identifying
antifreeze protein by incorporating grey model and PSSM into PseAAC," vol. 249, no. 6, pp. 845-854, 2016.

M. Kabir et al., "Improving prediction of extracellular matrix proteins using evolutionary information via
a grey system model and asymmetric under-sampling technique," vol. 174, pp. 22-32, 2018.
}
