% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AATP_TPC.R
\name{AATP_TPCC}
\alias{AATP_TPCC}
\title{AATP_TPC feature vector}
\usage{
AATP_TPCC(pssm_name)
}
\arguments{
\item{pssm_name}{is name of PSSM Matrix file}
}
\value{
a feature vector of length 420
}
\description{
For getting this feature which was used to protein structural class prediction,
at first mean of every column in PSSM Matrix is computed to achieve a 20-dimensional vector
called AAC.then by fusing it with other vector of length 400 called TPC, which is similar to \code{\link{DPC_PSSM}}
AATP feature vector of length 420 is obtained.
}
\examples{
as<-AATP_TPCC(paste0(system.file("extdata",package="PSSMCOOL"),"/C7GQS7.txt.pssm"))
}
\references{
Zhang, S., Ye, F. and Yuan, X. (2012) Using principal component analysis and support vector machine to predict protein
structural class for low-similarity sequences via PSSM, Journal of Biomolecular Structure & Dynamics, 29, 634-642.
}
\seealso{
\code{\link{DPC_PSSM}}
}
