% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MxRestore.R
\name{mxSave}
\alias{mxSave}
\title{Save model state to a checkpoint file}
\usage{
mxSave(model, chkpt.directory = ".", chkpt.prefix = "")
}
\arguments{
\item{model}{an \link{MxModel} object}

\item{chkpt.directory}{character. Directory where the checkpoint file is located}

\item{chkpt.prefix}{character. Prefix of the checkpoint file}
}
\value{
Returns a logical indicating the success of writing the checkpoint file to the checkpoint directory.
}
\description{
The function saves the last state of a model to a checkpoint file.
}
\details{
In general, the arguments \sQuote{chkpt.directory} and \sQuote{chkpt.prefix} should be identical to the \code{\link{mxOption}}: \sQuote{Checkpoint Directory} and \sQuote{Checkpoint Prefix} that were specified on the model before execution.

Alternatively, the checkpoint file can be manually loaded as a data.frame in R.  Use \code{\link{read.table}} with the options \code{header=TRUE, sep="\t", stringsAsFactors=FALSE, check.names=FALSE}.
}
\examples{
library(OpenMx)

# Simulate some data

x=rnorm(1000, mean=0, sd=1)
y= 0.5*x + rnorm(1000, mean=0, sd=1)
tmpFrame <- data.frame(x, y)
tmpNames <- names(tmpFrame)

dir <- tempdir()  # safe place to create files
mxOption(key="Checkpoint Directory", value=dir)

# Create a model that includes an expected covariance matrix,
# an expectation function, a fit function, and an observed covariance matrix

data <- mxData(cov(tmpFrame), type="cov", numObs = 1000)
expCov <- mxMatrix(type="Symm", nrow=2, ncol=2, values=c(.2,.1,.2), free=TRUE, name="expCov")
expFunction <- mxExpectationNormal(covariance="expCov", dimnames=tmpNames)
fitFunction <- mxFitFunctionML()
testModel <- mxModel(model="testModel", expCov, data, expFunction, fitFunction)

#Use mxRun to optimize the free parameters in the expected covariance matrix
modelOut <- mxRun(testModel)
modelOut$expCov

# Save the ending state of modelOut in a checkpoint file
mxSave(modelOut)

# Restore the saved model from the checkpoint file
modelSaved <- mxRestore(testModel)
modelSaved$expCov
}
\references{
The OpenMx User's guide can be found at \url{http://openmx.ssri.psu.edu/documentation}
}
\seealso{
Other model state: \code{\link{mxComputeCheckpoint}},
  \code{\link{mxRestore}}
}
\concept{model state}
