% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.ODEnetwork}
\alias{plot.ODEnetwork}
\title{Plots Results of ODEnetwork}
\usage{
\method{plot}{ODEnetwork}(x, ..., state = "12", var = NULL)
}
\arguments{
\item{x}{[\code{ODEnetwork}]\cr
List of class \code{\link{ODEnetwork}}.}

\item{...}{Additional arguments.}

\item{state}{[\code{character}]\cr
The type of result, that is plotted.
If \code{1}, only state1 (position or angle) is plotted over time.
If \code{2}, only state2 (velocity or magnitude) is plotted over time.
If \code{12}, state1 and state2 are plotted over time.
If \code{1vs2}, state2 is plotted over state1.
Default is \code{state12}}

\item{var}{[\code{numeric(n)}]\cr
Subset of variables to plot. Default is \code{NULL}, which plots all variables.}
}
\description{
Plots the results of \code{simuNetwork} of the given \code{\link{ODEnetwork}}
in different ways.
}
\examples{
masses <- c(1, 2)
dampers <- diag(c(0.1, 0.5))
dampers[1, 2] <- 0.05
springs <- diag(c(4, 10))
springs[1, 2] <- 6
odenet <- ODEnetwork(masses, dampers, springs)
odenet <- setState(odenet, c(1, 3), c(0, 0))
odenet <- simuNetwork(odenet, seq(0, 10, by = 0.05))
plot(odenet)
plot(odenet, var = 2L)
plot(odenet, state = "1")
plot(odenet, state = "2")
plot(odenet, state = "1vs2")
}
