% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotContour.R
\name{plotContour}
\alias{plotContour}
\title{Contour plot of latent node positions}
\usage{
plotContour(OUT, main = "", k = 8, my.cols = brewer.pal(k, "Spectral"))
}
\arguments{
\item{OUT}{Output of networkchange objects.}

\item{main}{The title of plot}

\item{k}{The number of levels (nlevels in contour ()).}

\item{my.cols}{Color scale. Use brewer.pal() from RColorBrewer.}
}
\value{
A plot object
}
\description{
Draw a contour plot of latent node positions
}
\examples{

   \dontrun{set.seed(1973)
   ## generate an array with two constant blocks
   Y <- MakeBlockNetworkChange(n=10, shape=10, T=40, type ="constant")
   out0 <- NetworkStatic(Y, R=2, mcmc=10, burnin=10,
   verbose=10, UL.Normal = "Orthonormal")
   ## contour plot of latent node positions
   plotContour(out0)
   }
}
