\name{sim.cppm}
\alias{sim.cppm}
\alias{print.sim.cpp}
\alias{plot.sim.cpp}
\title{Simulation for Neyman-Scott Cluster Point Process Models and Their
 Extensions}
\description{
  Simulation for the Thomas and Inverse-power type models, and the extended
 Thomas models of type A, B, and C.
}
\usage{
sim.cppm(model = "Thomas", pars, seed = NULL)

\method{print}{sim.cpp}(x, \dots)
\method{plot}{sim.cpp}(x, parents.distinct = FALSE, \dots)
}
\arguments{
  \item{model}{a character string indicating each cluster point process model:
    \code{"Thomas"}, \code{"IP"}, \code{"TypeA"}, \code{"TypeB"}, and
    \code{"TypeC"}.}
  \item{pars}{a named vector giving the values of each parameter. See 'Details'.}
  \item{seed}{arbitrary positive integer to generate a sequence of uniform
    random numbers. The default seed is based on the current time.}
  \item{x}{an object of class \code{"sim.cpp"}.}
  \item{parents.distinct}{logical. If \code{TRUE}, simulated points are
    distinguished by two groups specified by parameters. (Only valid if
    \code{model} = \code{"TypeB"} or \code{"TypeC"}.)}
  \item{\dots}{further graphical parameters from \code{\link{par}}
    for \code{plot} or ignored for \code{print}.}
}
\details{
  We consider the five cluster point process models: the Thomas and
  Inverse-power type models, and the extended Thomas models of type A, B, and C.

  \itemize{
    \item{\code{"Thomas" }}{
      (Thomas model)

	  The parameters of the model are as follows: 
      \itemize{
        \item \code{mu}: the intensity of parent points.
	    \item \code{nu}: the expectation of a random number of descendant points
              of each parent point.
        \item \code{sigma}: the parameter set of the dispersal kernel.
      }

      Let a random variable \eqn{U} be independently and uniformly distributed
      in [0,1].

      Consider
      \deqn{U = \int_0^r q_\sigma(t)dt =
              1 - \exp \left( -\frac{r^2}{2\sigma^2} \right),}{%
            U = integral_0^r q_\sigma(t)dt = 1 - exp(-r^2/(2\sigma^2)),}

      where \eqn{r} is the random variable of the distance between each parent
      point and the descendant points associated with the given parent. The
      distance is distributed independently and identically according to the
      dispersal kernel.
			
      We have
	  
      \deqn{r = \sigma \sqrt{-2 \log(1-U)}.}{%
            r = \sigma \sqrt{ -2log(1-U) }.}

      Let \eqn{(x_i^p, y_i^p), i=1,2,\dots, I,} be a coordinate of each parent
      point where the integer \eqn{I} is generated from the Poisson random
      variable \eqn{Poisson(\mu)} with mean \eqn{\mu} from now on. Then, for
      each \eqn{i}, the number of offspring \eqn{J_i} is generated by the random
      variable \eqn{Poisson(\nu)} with mean \eqn{\nu}. Then, using series of
      different uniform random numbers \eqn{\{U\}}{{U}} for different \eqn{i}
	  and \eqn{j}, each of the offspring coordinates
      \eqn{(x_j^i, y_j^i), j=1,2,\dots,J_i} is given by
	  
      \deqn{x_j^i = x_i^p + r \cos(2 \pi U),}{%
            x_j^i = x_i^p + r cos(2\piU),}
      \deqn{y_j^i = y_i^p + r \sin(2 \pi U),}{%
            y_j^i = y_i^p + r sin(2\piU),}

      owing to the isotropy condition of the distribution.

      Given a positive number \eqn{\nu} and let a sequence of a random variable
      \eqn{\{U_k\}}{{Uk}} be independently and uniformly distributed in [0,1],
      the Poisson random number \eqn{M} is the smallest integer such that
      \deqn{\sum_{k=1}^{M+1} - \log U_k > \nu,}{%
	    \sum_{k=1}^{M+1} - log Uk > \nu,}
      where \eqn{\log}{log} represents natural logarithm.
    }
  }
  \itemize{
    \item{\code{"IP"} }{
	  (Inverse-power type model)

	  The parameters of the model are as follows: 
	  \itemize{
        \item \code{mu}: the intensity of parent points.
	    \item \code{nu}: the expectation of a random number of descendant points
              of each parent point.
        \item \code{p}, \code{c}: the set of parameters of the dispersal kernel,
              where \code{p} > 1 and \code{c} > 0.
      }

      Let \eqn{U} be as above.

	  For all \eqn{r \ge 0}{r>=0},
	  
      \deqn{Q_{p,c}(r) := \int_0^r q_{p,c}(t)dt}{%
            Q_{p,c}(r) := integral_0^r q_{p,c}(t)dt}
      \deqn{= c^{p-1}(p-1) \frac{(r+c)^{1-p} - c^{1-p}}{1-p}}{%
            = c^{p-1} (p-1) {(r+c)^{1-p} - c^{1-p}}/(1-p)}
      \deqn{= 1 - c^{p-1} (r+c)^{1-p}.}{%
            = 1 - c^{p-1} (r+c)^{1-p}.}
			
      Here, we put \eqn{Q_{p,c}(r) = U}. From this, we have
	  
      \deqn{r = c\{(1-U)^{1/(1-p)} - 1\}.}{%
            r = c {(1-U)^{1/(1-p)} - 1}.}

      The parent points and their descendant points are generated the same as
      the Thomas model.
    }
  }
  \itemize{
    \item{\code{"TypeA"} }{
      (Type A model)

      The parameters of the model are as follows: 
	  \itemize{
        \item \code{mu}: the intensity of parent points.
	    \item \code{nu}: the expectation of a random number of descendant points
              of each parent point.
        \item \code{a}, \code{sigma1}, \code{sigma2}: the set of parameters of
              the dispersal kernel, where where \code{a} is a mixture ratio
              parameter with 0 < \code{a} < 1. 
      }

      Let each random variable \eqn{U_k, k=1,2}{Uk, k=1,2}, be independently and
      uniformly distributed in [0,1].

	  Then \eqn{r} satisfies as follows: 
	  
      \deqn{r = \sigma_1 \sqrt{-2 \log(1-U_1)},  \quad U_2 \le a ,}{%
            r = \sigma1 \sqrt{ -2log(1-U1) },  U2 <= a ,}
      \deqn{r = \sigma_2 \sqrt{-2 \log(1-U_1)},  \quad \mathrm{otherwise.}}{%
            r = \sigma2 \sqrt{ -2log(1-U1) }, otherwise.}

      The parent points and their descendant points are generated the same as
      the Thomas model.
    }
  }
  \itemize{
    \item{\code{"TypeB"} }{
      (Type B model)

	  The TypeB is a superposed Thomas model. The parameters of the model are as
      follows: 
	  \itemize{
        \item \code{mu1}, \code{mu2}: the corresponding intensity of parent
              points of each Thomas model.
	    \item \code{nu}: the expectation of a random number of descendant points
              of each parent point.
        \item \code{sigma1}, \code{sigma2}: the corresponding set of parameters
              of the dispersal kernel of each Thomas model.
      }
	
      Consider the two types of the Thomas model with parameters
      \eqn{(\mu_1, \nu, \sigma_1)}{(\mu1, \nu, \sigma1)} and
      \eqn{(\mu_2, \nu, \sigma_2)}{(\mu2, \nu, \sigma2)}.
      Parents' configuration and numbers of the descendant cluster sizes are
      generated by the two types of uniformly distributed parents
      \eqn{(x_i^k, y_i^k)} with
      \eqn{i=1,2,\dots,Poisson(\mu_k)}{i=1,2,...,Poisson(\muk)} for \eqn{k=1,2},
      respectively.

      Then, using series of different uniform random numbers \eqn{\{U\}}{{U}}
	  for different \eqn{i} and \eqn{j}, each of the descendant coordinates
      \eqn{(x_j^{k,i}, y_j^{k,i})} of the parents \eqn{(x_i^k, y_i^k)},
      \eqn{k=1,2}, \eqn{j=1,2,\dots,Poisson(\nu)}{j=1,2,...,Poisson(\nu)}, is 
      given by
	  
      \deqn{x_j^{k,i} = x_i^k + r_k \cos (2 \pi U),}{%
            x_j^{k,i} = x_i^k + r_k cos (2\piU),}
      \deqn{y_j^{k,i} = y_i^k + r_k \sin (2 \pi U),}{%
            y_j^{k,i} = y_i^k + r_k sin (2\piU),}
			
      where
	  
      \deqn{r_k = \sigma_k \sqrt{-2 \log (1-U_k)}, \quad k = 1, 2,}{%
            r_k = \sigmak \sqrt{ -2log(1-Uk) },  k = 1, 2,}
			
      with different random numbers \eqn{\{U_k, U\}}{{Uk, U}} for different
      \eqn{k, i}, and \eqn{j}.
    }
  }
  \itemize{
    \item{\code{"TypeC"} }{
      (Type C model)

	  The TypeC is a superposed Thomas model. The parameters of the model are as
      follows: 
	  \itemize{
        \item \code{mu1}, \code{mu2}: the corresponding intensity of parent
              points of each Thomas model.
	    \item \code{nu1}, \code{nu2}: the corresponding expectation of a random
              number of descendant points of each Thomas model.
        \item \code{sigma1}, \code{sigma2}: the corresponding set of parameters
              of the dispersal kernel of each Thomas model.
      }

      The parent points and their descendant points are generated the same as
      the Type B model.
	}
  }
}
\value{
  \code{sim.cppm} returns an object of class \code{"sim.cpp"} containing the
  following components which has \code{print} and \code{plot} methods.
  \item{parents}{a list containing two components named "\code{n}" and
    "\code{xy}", which are the number and the matrix of \code{(x,y)} coordinates
    of simulated parent points, respectively. For \code{"TypeB"}, \code{xy}
    [1:\code{n}[1], 1:2] and the remainder are generated from (\code{mu1}, 
    \code{nu}, \code{sigma1}) and (\code{mu2}, \code{nu}, \code{sigma2}), 
    respectively. For \code{"TypeC"}, \code{xy}[1:\code{n}[1], 1:2] and the
    remainder are generated from (\code{mu1}, \code{nu1}, \code{sigma1}) and
    (\code{mu2}, \code{nu2}, \code{sigma2}), respectively.}
  \item{offspring}{a list containing two components named "\code{n}" and
    "\code{xy}", which are the number and the matrix of \code{(x,y)} coordinates
    of simulated descendant points, respectively. For \code{"TypeB"}, \code{xy}
    [1:\code{n}[1], 1:2] and the remainder are generated from (\code{mu1},
    \code{nu}, \code{sigma1}) and (\code{mu2}, \code{nu}, \code{sigma2}),
    respectively. For \code{"TypeC"}, \code{xy}[1:\code{n}[1], 1:2] and the
    remainder are generated from (\code{mu1}, \code{nu1}, \code{sigma1}) and
    (\code{mu2}, \code{nu2}, \code{sigma2}), respectively.}
}
\references{
Tanaka, U., Ogata, Y. and Katsura, K. (2008)
 Simulation and estimation of the Neyman-Scott type spatial cluster models.
 \emph{Computer Science Monographs} \bold{34}, 1-44.
 The Institute of Statistical Mathematics, Tokyo.
 \url{https://www.ism.ac.jp/editsec/csm/}.
}
\examples{
## Thomas Model
pars <- c(mu = 50.0, nu = 30.0, sigma = 0.03)
t.sim <- sim.cppm("Thomas", pars, seed = 117)
t.sim
plot(t.sim)

## Inverse-Power Type Model
pars <- c(mu = 50.0, nu = 30.0, p = 1.5, c = 0.005)
ip.sim <- sim.cppm("IP", pars, seed = 353)
ip.sim
plot(ip.sim)

## Type A Model
pars <- c(mu = 50.0, nu = 30.0, a = 0.3, sigma1 = 0.005, sigma2 = 0.1)
a.sim <- sim.cppm("TypeA", pars, seed = 575)
a.sim
plot(a.sim)

## Type B Model
pars <- c(mu1 = 10.0, mu2 = 40.0, nu = 30.0, sigma1 = 0.01, sigma2 = 0.03)
b.sim <- sim.cppm("TypeB", pars, seed = 257)
b.sim
plot(b.sim, parents.distinct = TRUE)

## Type C Model
pars <- c(mu1 = 5.0, mu2 = 9.0, nu1 = 30.0, nu2 = 150.0,
               sigma1 = 0.01, sigma2 = 0.05)
c.sim <- sim.cppm("TypeC", pars, seed = 555)
c.sim
plot(c.sim, parents.distinct = FALSE)
}
\keyword{spatial}
