\name{SimulateTypeA}
\alias{SimulateTypeA}
\title{Simulation of the Generalized Thomas Model of Type A}
\description{
  Simulation of the Generalized Thomas Model of Type A.
}
\usage{
  SimulateTypeA(seeds, pa, ty=1, pmax=100, omax=3000, plot=TRUE)
}
\arguments{
  \item{seeds}{the three positive integer variables, which are initial seeds for a sequence of uniform random numbers.}
  \item{pa}{the parameter values \eqn{(\mu, \nu, a, \sigma_1, \sigma_2)}{(mu, nu, a, sigma_1, sigma_2)} for the random variable Poisson.}
  \item{ty}{the variable \eqn{T_y}{Ty} for the standardized coordinates of points in the rectangular region \eqn{[0,1] \times [0,T_y]}{[0,1]*[0,Ty]} without loss of generality except for the scaling.}
  \item{pmax}{maximum number of parent points.}
  \item{omax}{maximum number of offspring points.}
  \item{plot}{logical. If TRUE (default) simulated parent points and offspring points are plotted.}
}
\value{
  \item{n.parents}{the number of simulated parent points.}
  \item{parents}{the coordinates of simulated parent points.}
  \item{n.offspring}{the total number of simulated offspring points.}
  \item{offspring}{the coordinates of simulated offspring points.}
}
\details{
  Parents' configuration and numbers of the offspring cluster sizes are generated by the same way as the Thomas model.

  Let random variable \eqn{U_k, k=1,2} be independently and uniformly distributed in [0,1].
  Then \eqn{r} satisfies as follows: 

  \deqn{r = \sigma_1 \sqrt{-2 \log(1-U_1)}, \; U_2 \le a,}{%
        r = sigma_1 sqrt{-2log(1-U_1)},  U_2 <= a,}
  \deqn{r = \sigma_2 \sqrt{-2 \log(1-U_1)}, \; otherwise.}{%
        r = sigma_2 sqrt{-2log(1-U_1)},  otherwise.}

  Then, by the isotropy condition, for \eqn{i = 1,2,...,Poisson(\mu)}{i = 1,2,...,Poisson(mu)},
  coordinate of the offspring points \eqn{(x_j^i, y_j^i), j=1,2,...,Poisson(\nu)}{(x_j^i, y_j^i), j=1,2,...,Poisson(nu)} is given for each \eqn{i=1,...,Poisson(\mu)}{i=1,...,Poisson(mu)},

  \deqn{x_j^i = x_i^p + r \cos(2 \pi U),}{%
        x_j^i = x_i^p + r cos(2 \pi U),}
  \deqn{y_j^i = y_i^p + r \sin(2 \pi U),}{%
        y_j^i = y_i^p + r sin(2 \pi U),}

  using series of different uniform random numbers \eqn{\{ U_1, U_2, U \}}{{U_1, U_2, U}} for different \eqn{i} and \eqn{j}.
}
\references{
  U. Tanaka, Y. Ogata and K. Katsura,
  Simulation and estimation of the Neyman-Scott type spatial cluster models, \emph{Computer Science Monographs} \bold{No.34}, 2008, 1-44.
  The Institute of Statistical Mathematics.
}
\examples{
  seeds <- c(822, 913, 905)
  mu <- 50;  nu <- 30;  a <- 0.3;  sig1 <- 0.005;  sig2 <- 0.1
  SimulateTypeA(seeds, c(mu,nu,a,sig1,sig2), pmax=100, omax=150)
}

\keyword{spatial}
