% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Partial_Moments.R
\name{PM.matrix}
\alias{PM.matrix}
\title{Partial Moment Matrix}
\usage{
PM.matrix(LPM.degree, UPM.degree, target = "mean", variable, pop.adj = FALSE)
}
\arguments{
\item{LPM.degree}{integer; Degree for \code{variable} below \code{target} deviations.  \code{(degree = 0)} is frequency, \code{(degree = 1)} is area.}

\item{UPM.degree}{integer; Degree for \code{variable} above \code{target} deviations.  \code{(degree = 0)} is frequency, \code{(degree = 1)} is area.}

\item{target}{numeric; Typically the mean of Variable X for classical statistics equivalences, but does not have to be. (Vectorized)  \code{(target = "mean")} (default) will set the target as the mean of every variable.}

\item{variable}{a numeric matrix or data.frame.}

\item{pop.adj}{logical; \code{FALSE} (default) Adjusts the sample co-partial moment matrices for population statistics.}
}
\value{
Matrix of partial moment quadrant values (CUPM, DUPM, DLPM, CLPM), and overall covariance matrix.  Uncalled quadrants will return a matrix of zeros.
}
\description{
This function generates a co-partial moment matrix for the specified co-partial moment.
}
\note{
For divergent asymmetical \code{"D.LPM" and "D.UPM"} matrices, matrix is \code{D.LPM(column,row,...)}.
}
\examples{
set.seed(123)
x <- rnorm(100) ; y <- rnorm(100) ; z <- rnorm(100)
A <- cbind(x,y,z)
PM.matrix(LPM.degree = 1, UPM.degree = 1, target = "mean", variable = A)

## Use of vectorized numeric targets (target_x, target_y, target_z)
PM.matrix(LPM.degree = 1, UPM.degree = 1, target = c(0, 0.15, .25), variable = A)

## Calling Individual Partial Moment Quadrants
cov.mtx <- PM.matrix(LPM.degree = 1, UPM.degree = 1, target = "mean", variable = A)
cov.mtx$cupm

## Full covariance matrix
cov.mtx$cov.matrix
}
\references{
Viole, F. and Nawrocki, D. (2013) "Nonlinear Nonparametric Statistics: Using Partial Moments"
\url{https://www.amazon.com/dp/1490523995/ref=cm_sw_su_dp}

Viole, F. (2017) "Bayes' Theorem From Partial Moments"
\url{https://www.ssrn.com/abstract=3457377}
}
\author{
Fred Viole, OVVO Financial Systems
}
