% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NMisNumeric.R
\name{NMisNumeric}
\alias{NMisNumeric}
\title{Test if a variable can be interpreted by Nonmem}
\usage{
NMisNumeric(x, na.strings = ".", each = FALSE)
}
\arguments{
\item{x}{The vector to check Don't export}

\item{na.strings}{Tolerated strings that do not translate to
numerics. Default is to accept "." because it's common to
write missing values that way to Nonmem (even if Nonmem will
handle them as zeros rather than missing). Notice actual NA's
are accepted so you may want to use na.strings=NULL if you
don't code missings as "." and just do this when writing the
data set to a delimited file (like NMwriteData will do for
you).}

\item{each}{Use each=TRUE to evaluate each element in a vector
individually. The default (each=FALSE) is to return a
single-length logical for a vector x summarizing whether all
the elements are numeric-compatible.}
}
\value{
TRUE or FALSE
}
\description{
Nonmem can only interpret numeric data. However, a
    factor or a character variable may very well be interpretable
    by Nonmem (e.g. "33"). This function tells whether Nonmem will
    be able to read it.
}
