% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{chmProperty}
\alias{chmProperty}
\title{Get the value of an NG-CHM property.}
\usage{
chmProperty(hm, label)
}
\arguments{
\item{hm}{The NG-CHM object to get the property value from.}

\item{label}{The name of the property to get.
If no property with that name exists, return NULL.

\if{html}{\out{<div class="sourceCode">}}\preformatted{   Well-known property labels used by the NG-CHM system include:

   * "chm.info.caption"  A paragraph describing the NG-CHM's contents (set by user).
  * "chm.info.built.time"  The date and time the NG-CHM was saved (set by system).
}\if{html}{\out{</div>}}}
}
\value{
A property value or NULL.
}
\description{
Get the value of an NG-CHM property.
}
\examples{
hm <- chmNew("Empty")
chmProperty(hm, "chm.info.caption")

}
\seealso{
\linkS4class{ngchm}
}
