% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-sts.R
\name{sts_check}
\alias{sts_check}
\title{Check \emph{sts} object for validity}
\usage{
sts_check(sts)
}
\arguments{
\item{sts}{\emph{sts} object.}
}
\value{
Returns \code{TRUE} invisibly if the \emph{sts} object is valid.
}
\description{
Checks on the validity of an \emph{sts} object. If any test
fails, this function will stop with a warning message.
}
\examples{
library(MazamaTimeSeries)

sts_check(example_sts)

# This would throw an error
if ( FALSE ) {

  broken_sts <- example_sts
  names(broken_sts) <- c('meta', 'bop')
  sts_check(broken_sts)

}

}
\seealso{
\link{sts_isValid}
}
