% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\name{return_mmc}
\alias{return_mmc}
\title{S3 class \code{mmc}.}
\usage{
return_mmc(S0, y, statistic, dgp, est, lower, upper, N, type, method,
  alpha, control, call, seed, lmc, opt_result, opt_trace)
}
\arguments{
\item{S0}{An atomic vector. Value of the test statistic
applied to the data.}

\item{y}{A vector or data frame.}

\item{statistic}{A function or a character string that specifies
how the statistic is computed. The function needs to input the
\code{y} and output a scalar.}

\item{dgp}{A function. The function inputs the first argument
\code{y} and a vector of nuisance parameters \code{v} and outputs a simulated \code{y}.
It should represent the data generating process under the null.
Default value is the function \code{sample(y, replace = TRUE)}, i.e. the
bootstrap resampling of \code{y}.}

\item{est}{A vector with length of v. It is the starting
point of the algorithm. If \code{est} is a consistent estimate
of \code{v} then \code{mmc} will return both the MMC and Local Monte Carlo (LMC).
Default is NULL, in which case, default values will be generated automatically.}

\item{lower}{A vector with length of v. Lower bounds for
nuisance parameters under the null. See Details.}

\item{upper}{A vector with length of v. Upper bounds for
nuisance parameters under the null. See Details.}

\item{N}{An atomic vector. Number of replications of the test
statistic.}

\item{type}{A character string. It specifies the type of test
the p-value function produces. The possible values are
\code{geq}, \code{leq}, \code{absolute} and \code{two-tailed}.
 Default is \code{geq}.}

\item{method}{A character string. Type of algorithm to be
used for global optimization. The four available methods
are simulated annealing (\code{\link{GenSA}}), particle swarm (\code{\link{pso}}),
genetic algorithm (\code{\link{GA}}), and grid search (\code{\link{gridSearch}})
Default is \code{GenSA},}

\item{alpha}{An atomic vector. If \code{mmc} finds a
p-value over \code{alpha}, then the algorithm will stop. This is particularly
useful if we are only looking at testing a hypothesis at a particular level.
Default is NULL.}

\item{control}{A list. Arguments to be used to control the
behavior of the algorithm chosen in \code{method}. See controls section for more details.}

\item{call}{An object of class \code{call}. Original call to \code{mmc}}

\item{seed}{An integer vector. Value of \code{.Random.seed} at the start of
\code{mmc} call.}

\item{lmc}{An object of class \code{mc}. If \code{par} is specified, it returns an object
of class \code{mc} corresponding the Local Monte Carlo test.}

\item{opt_result}{An object returning the optimization results.}

\item{opt_trace}{An object returning the optimization results.}
}
\description{
S3 class \code{mmc}.
}
\examples{
# Generate typical data found inside the function mmc()
S0 <-  0
y <-  rnorm(100)
statistic <-  function(y, v) mean(y) * v
dgp <-  function(y, v) sample(y, replace = TRUE)
est <- 1
lower <- -1
upper <- 1
N <-  99
type <-  "geq"
method <- "GenSA"
alpha <- 0.05
control <- MaxMC:::get_control(method)
call <- call("mc",y= y, statistic = statistic, dgp = dgp, N = 99, type = type)
seed <-  NULL
lmc <- list(pval = 0.10)
pval <-  0.65
opt_result <- list(value = 0.10)
opt_trace  <- as.data.frame(matrix(data = NA, control$maxit, 3,
                                   dimnames = list(NULL,c("ite","pval","max"))))

# Combine data and return it as an object of class 'mmc'
MaxMC:::return_mmc(S0 = S0, y = y, statistic = statistic, dgp = dgp, est = est, lower = lower,
                   upper = upper, N = N, type = type, method = method, alpha = alpha,
                   control = control, call = call, seed = seed, lmc = lmc,
                   opt_result = opt_result, opt_trace = opt_trace)
}
\keyword{internal}
