% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_smd_comparison.R
\name{plot_ps_qq}
\alias{plot_ps_qq}
\title{Draw QQ plots of propensity score between groups before and after matching}
\usage{
plot_ps_qq(mi_obj = NULL)
}
\arguments{
\item{mi_obj}{A matchit object derived from MatchIt pacakge}
}
\value{
Return a list of relevant data, code, and QQ plot
}
\description{
This function accepts a MatchIt object (i.e., the result of matchit function)
and draw side-by-side QQ plots of propensity score between groups before and
after matching, for the purpose of comparison. Note only the results of
Subclassification, Nearest Neighbor Matching, Optimal Matching, Full
Matching, and Genetic Matching are acceptable. The results of Exact Matching
is not applicable to this function.
}
\examples{
# take lalonde data as an example
 m_out <- MatchIt::matchit(treat ~ re74 + re75 + age + educ + hispan +
    black, data = MatchIt::lalonde, method = "nearest")
 plot_ps_qq(m_out)

}
\seealso{
plot_smd()
}
\keyword{QQ}
\keyword{plot}
