% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mvn.R
\name{mvn}
\alias{mvn}
\title{Multivariate Normality Tests}
\usage{
mvn(data, subset = NULL, mvnTest = c("mardia", "hz", "royston", "dh",
  "energy"), covariance = TRUE, scale = FALSE, desc = TRUE,
  transform = "none", R = 1000, univariateTest = c("SW", "CVM", "Lillie",
  "SF", "AD"), univariatePlot = "none", multivariatePlot = "none",
  multivariateOutlierMethod = "none", showOutliers = FALSE,
  showNewData = FALSE)
}
\arguments{
\item{data}{a numeric matrix or data frame}

\item{subset}{define a variable name if subset analysis is required}

\item{mvnTest}{select one of the MVN tests. Type \code{"mardia"} for Mardia's test, \code{"hz"} for Henze-Zirkler's test, \code{"royston"} for Royston's test, \code{"dh"} for Doornik-Hansen's test and \code{energy} for E-statistic. See details for further information.}

\item{covariance}{this option works for \code{"mardia"} and \code{"royston"}. If \code{TRUE} covariance matrix is normalized by \code{n}, if \code{FALSE} it is normalized by \code{n-1}}

\item{scale}{if \code{TRUE} scales the colums of data}

\item{desc}{a logical argument. If \code{TRUE} calculates descriptive statistics}

\item{transform}{select a transformation method to transform univariate marginal via logarithm (\code{"log"}), square root (\code{"sqrt"}) and square (\code{"square"}).}

\item{R}{number of bootstrap replicates for Energy test, default is 1000.}

\item{univariateTest}{select one of the univariate normality tests, Shapiro-Wilk (\code{"SW"}), Cramer-von Mises (\code{"CVM"}), Lilliefors (\code{"Lillie"}), Shapiro-Francia (\code{"SF"}), Anderson-Darling (\code{"AD"})}

\item{univariatePlot}{select one of the univariate normality plots, Q-Q plot (\code{"qq"}), histogram (\code{"histogram"}), box plot (\code{"box"}), scatter (\code{"scatter"})}

\item{multivariatePlot}{\code{"qq"} for chi-square Q-Q plot, \code{"persp"} for perspective plot, \code{"contour"} for contour plot}

\item{multivariateOutlierMethod}{select multivariate outlier detection method, \code{"quan"} quantile method based on Mahalanobis distance and \code{"adj"} adjusted quantile method based on Mahalanobis distance}

\item{showOutliers}{if \code{TRUE} prints multivariate outliers}

\item{showNewData}{if \code{TRUE} prints new data without outliers}
}
\value{
\code{multivariateNormality} corresponding multivariate normality test statistics and p-value

\code{univariateNormality} corresponding univariate normality test statistics and p-value

\code{Descriptives} Descriptive statistics

\code{multivariateOutliers} multivariate outliers

\code{newData} new data without multivariate outliers

multivariate normality plots, Q-Q, perspective or contour

chi-square Q-Q plot for multivariate outliers

univariate normality plots, Q-Q plot, histogram, box plot, scatter
}
\description{
Performs multivariate normality tests, including Marida, Royston, Henze-Zirkler, Dornik-Haansen, E-Statistics
}
\details{
If \code{mvnTest = "mardia"}, it calculate the Mardia's multivariate skewness and kurtosis coefficients as well as their corresponding statistical significance.
It can also calculate corrected version of skewness coefficient for small sample size (n< 20).
For multivariate normality, both p-values of skewness and kurtosis statistics should be greater than 0.05.
If sample size less than 20 then p.value.small should be used as significance value of skewness instead of p.value.skew.
If there are missing values in the data, a listwise deletion will be applied and a complete-case analysis will be performed.

If \code{mvnTest = "hz"}, it calculate the Henze-Zirkler's multivariate normality test. The Henze-Zirkler test is based on a non-negative functional distance that measures the distance between two distribution functions. If the data is multivariate normal, the test statistic HZ is approximately lognormally distributed. It proceeds to calculate the mean, variance and smoothness parameter. Then, mean and variance are lognormalized and the p-value is estimated.
If there are missing values in the data, a listwise deletion will be applied and a complete-case analysis will be performed.

If \code{mvnTest = "royston"}, it calculate the Royston's multivariate normality test. A function to generate the Shapiro-Wilk's W statistic needed to feed the Royston's H test for multivariate normality However, if kurtosis of the data greater than 3 then Shapiro-Francia test is used for leptokurtic samples else Shapiro-Wilk test is used for platykurtic samples.
If there are missing values in the data, a listwise deletion will be applied and a complete-case analysis will be performed.
}
\examples{
result = mvn(data = iris[-4], subset = "Species", mvnTest = "hz",
             univariateTest = "AD", univariatePlot = "histogram",
             multivariatePlot = "qq", multivariateOutlierMethod = "adj",
             showOutliers = TRUE, showNewData = TRUE)

#### Multivariate Normality Result
result$multivariateNormality

### Univariate Normality Result
result$univariateNormality

### Descriptives
result$Descriptives

### Multivariate Outliers
result$multivariateOutliers

### New data without multivariate outliers
result$newData

# Note that this function also creates univariate histograms,
# multivariate Q-Q plots for multivariate normality assessment
# and multivariate outlier detection.

}
\author{
Selcuk Korkmaz, \email{selcukorkmaz@gmail.com}
}
