% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate.R
\name{simulate.MSGARCH_SPEC}
\alias{simulate.MSGARCH_SPEC}
\alias{simulate.MSGARCH_ML_FIT}
\alias{simulate.MSGARCH_MCMC_FIT}
\title{Simulation of MSGARCH processes.}
\usage{
\method{simulate}{MSGARCH_SPEC}(
  object,
  nsim = 1L,
  seed = NULL,
  nahead = 1L,
  par = NULL,
  nburn = 500L,
  ...
)

\method{simulate}{MSGARCH_ML_FIT}(object, nsim = 1L, seed = NULL, nahead = 1L, nburn = 500L, ...)

\method{simulate}{MSGARCH_MCMC_FIT}(object, nsim = 1L, seed = NULL, nahead = 1L, nburn = 500L, ...)
}
\arguments{
\item{object}{Model specification of class \code{MSGARCH_SPEC} created with \code{\link{CreateSpec}}
or fit object of type \code{MSGARCH_ML_FIT} created with \code{\link{FitML}} or \code{MSGARCH_MCMC_FIT}
created with \code{\link{FitMCMC}}.}

\item{nsim}{Number of simulations. (Default: \code{nsim = 1L})}

\item{seed}{Integer indicating if and how the random number generator should be initialized. 
If \code{seed = NULL}, the state of the random generator will not change. (Default: \code{seed = NULL})}

\item{nahead}{Simulation length. (Default: \code{nahead = 1L})}

\item{par}{Vector (of size d) or matrix (of size \code{nahead} x d) of parameter}

\item{nburn}{Burnin period discarded (first simulation draws).}

\item{...}{Not used. Other arguments to \code{simulate}.}
}
\value{
A list of class \code{MSGARCH_SIM} with the following elements:.
\itemize{
\item \code{draw}: Matrix (of size \code{nahead} x \code{nsim}) of simulated draws.
\item \code{state}: Matrix (of size \code{nahead} x \code{nsim}) of simulated states.
\item \code{CondVol}: Array (of size \code{nahead} x \code{nsim} x K) of simulated conditional volatilities.  
}
The \code{MSGARCH_SIM} class contains the \code{plot} method.
}
\description{
Method for simulating \code{MSGARCH} processes.
}
\details{
If a matrix of parameters estimates is provided, \code{nsim} simuations will be done for each row.
}
\examples{
# create specification
spec <- CreateSpec()

# simulation from specification
par <- c(0.1, 0.1, 0.8, 0.2, 0.1, 0.8, 0.99, 0.01)
set.seed(1234)
sim <- simulate(object = spec, nsim = 1L, nahead = 1000L, 
                nburn = 500L, par = par)
head(sim)
plot(sim)

# load data
data("SMI", package = "MSGARCH")

# simulation from ML fit
fit <- FitML(spec = spec, data = SMI)
set.seed(1234)
sim <- simulate(object = fit, nsim = 1L, nahead = 1000L, 
                nburn = 500L)
head(sim)
plot(sim)

\dontrun{
# simulation from MCMC fit
fit <- FitMCMC(spec = spec, data = SMI)
set.seed(1234)
sim <- simulate(object = fit, nahead = 100L, nburn = 500L)
head(sim)
plot(sim)
}
}
