% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ToBtoLevel1.R
\name{labelIntNodes}
\alias{labelIntNodes}
\title{Label internal nodes on tree}
\usage{
labelIntNodes(tree, plot = TRUE, type = "unrooted")
}
\arguments{
\item{tree}{a rooted or unrooted tree (phylo object)}

\item{plot}{TRUE for plot, FALSE for no plot}

\item{type}{plot type (e.g.,"unrooted") to be passed to ape plot command}
}
\value{
a phylo object with internal node labels
}
\description{
Label all internal nodes of tree, as "Node NN" where NN is the node number, and
plot tree with labels
}
\examples{
data(pTableYeastRokas)
out=TINNIK(pTableYeastRokas,test="T3",alpha=.01, beta=.05)
labelIntNodes(out$ToB)

}
\seealso{
\code{\link{resolveCycle}}, \code{\link{combineCycleResolutions}},
  \code{\link{resolveLevel1}}
}
