% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcee_helper_nuisance_config.R
\name{mcee_config_gam}
\alias{mcee_config_gam}
\title{Configure GAM for MCEE nuisance parameters}
\usage{
mcee_config_gam(target, formula, family = NULL, clipping = NULL)
}
\arguments{
\item{target}{Character. Nuisance parameter name ("p", "q", "eta", "mu", "nu").}

\item{formula}{RHS-only formula (e.g., \code{~ X1 + s(time) + s(X2, k=5)}).}

\item{family}{Optional GLM family. Defaults to \code{binomial()} for "p"/"q",
\code{gaussian()} for "eta"/"mu"/"nu".}

\item{clipping}{Optional numeric vector \code{c(lo, hi)} to clip predictions
into [lo, hi] for numerical stability.}
}
\value{
A configuration list for use with \code{\link{mcee_general}}.
}
\description{
Creates a configuration to fit nuisance parameters using generalized additive models
via \code{mgcv::gam()}. Supports smooth terms like \code{s()}.
}
\examples{
# GAM with smooth time effect
cfg_eta <- mcee_config_gam("eta", ~ X1 + s(dp, k = 4))

# GAM with multiple smooths
cfg_mu <- mcee_config_gam("mu", ~ s(dp) + s(M, X1, k = 10))
}
