% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.MGLM.R
\docType{methods}
\name{predict}
\alias{predict}
\alias{predict,MGLMreg,ANY-method}
\alias{predict,MGLMreg-method}
\alias{predict,MGLMreg}
\title{Predict method for MGLM Fits}
\usage{
\S4method{predict}{MGLMreg}(object, newdata)
}
\arguments{
\item{object}{model object.}

\item{newdata}{new covariates data matrix.}
}
\value{
Outputs the probabilities of each category.

This helps answer questions such as whether certain features increase the probability of observing category j.
}
\description{
Predict using the fitted model from \code{MGLMreg} when given a new set of covariates.
}
\examples{
n <- 200
p <- 5
d <- 4
X <- matrix(runif(p * n), n, p)
alpha <- matrix(c(0.6, 0.8, 1), p, d - 1, byrow=TRUE)
alpha[c(1, 2),] <- 0
Alpha <- exp(X \%*\% alpha) 
beta <- matrix(c(1.2, 1, 0.6), p, d - 1, byrow=TRUE)
beta[c(1, 2),] <- 0
Beta <- exp(X \%*\% beta)
m <- runif(n, min=0, max=25) + 25
Y <- rgdirmn(n, m, Alpha, Beta)
gdmReg <- MGLMreg(Y~0+X, dist="GDM")
newX <- matrix(runif(1*p), 1, p)
pred <- predict(gdmReg, newX)

}
