% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pairwise.cor.test.R
\name{pairwise.cor.test}
\alias{pairwise.cor.test}
\title{Pairwise Tests for Association/Correlation Between Paired Samples}
\usage{
pairwise.cor.test(x, g, p.adjust.method = p.adjust.methods,
  method = c("pearson", "kendall", "spearman"), ...)
}
\arguments{
\item{x}{response vector.}

\item{g}{grouping vector or factor.}

\item{p.adjust.method}{method for adjusting p values (see \code{\link[stats]{p.adjust}}). Can be abbreviated.}

\item{method}{string argument to set the method to compute the correlation. Possibilities are "pearson" (the default), "kendall", and "spearman"}

\item{...}{additional arguments passed to \code{\link[stats]{cor.test}}.}
}
\value{
Object of class \code{pairwise.htest}
}
\description{
Calculate pairwise correlations between group levels with corrections for multiple testing.
}
\details{
Note that correlation tests require that the two vectors examined are of the same length.
Thus, if the grouping defines groups of varying lengths then the specific correlation is
not computed and a \code{NA} is returned instead. The adjusted p values are only based on
the actual correlation that are computed.
Extra arguments that are passed on to \code{cor.test} may or may not be sensible in this context.
}
\examples{

attach(airquality)
Month <- factor(Month, labels = month.abb[5:9])
pairwise.cor.test(Ozone, Month)
pairwise.cor.test(Ozone, Month, p.adj = "bonf")
detach()
}
