\name{power.binom.test}
\alias{power.binom.test}
\title{Power Calculations for Exact Test of a simple null hypothesis in a Bernoulli experiment}
\description{
Compute power of test, or determine parameters to obtain target power.
}
\usage{
power.binom.test(n = NULL, p0 = NULL, pa = NULL, sig.level = 0.05, 
                 power = NULL, alternative = c("two.sided", "less", "greater"))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{n}{Number of observations}
  \item{p0}{Probability under the null}
  \item{pa}{Probability under the alternative}
  \item{sig.level}{Significance level (Type I error probability)}
  \item{power}{Power of test (1 minus Type II error probability)}
  \item{alternative}{One- or two-sided test}
}
\details{The procedure uses uniroot to find the root of a discontinuous function so some errors may pop up due to the given setup that causes the root-finding procedure to fail. Also, since exact binomial tests are used we have discontinuities in the function that we use to find the root of but despite this the function is usually quite stable.}
\value{
Object of class \code{power.htest}, a list of the arguments (including the computed one) augmented with method and note elements.
%%  ~Describe the value returned
%%  If it is a LIST, use
%%  \item{comp1 }{Description of 'comp1'}
%%  \item{comp2 }{Description of 'comp2'}
%% ...
}
%\references{
%% ~put references to the literature/web site here ~
%}
\author{
Claus Ekstrom \email{claus@rprimer.dk}
}
%\note{
%%  ~~further notes~~
%}

\seealso{
\code{\link{binom.test}}
}
\examples{
##---- Should be DIRECTLY executable !! ----
##-- ==>  Define data, use random,
##--	or do  help(data=index)  for the standard data sets.

## The function is currently defined as
function (n = NULL, p0 = NULL, pa = NULL, sig.level = 0.05, power = NULL, 
    alternative = c("two.sided", "less", "greater")) 
{
    if (sum(sapply(list(n, p0, pa, power, sig.level), is.null)) != 
        1) 
        stop("exactly one of 'n', 'p0', 'pa', 'power', and 'sig.level' must be NULL")
    if (!is.null(sig.level) && !is.numeric(sig.level) || any(0 > 
        sig.level | sig.level > 1)) 
        stop("'sig.level' must be numeric in [0, 1]")
    alternative <- match.arg(alternative)
    pfun <- function(n, p0, pa, sig.level, alternative) {
        n <- ceiling(n)
        power <- switch(alternative, less = {
            pbinom(qbinom(1 - sig.level, size = n, prob = p0, 
                lower.tail = FALSE) - 1, size = n, prob = pa)
        }, greater = {
            pbinom(qbinom(1 - sig.level, size = n, prob = p0), 
                size = n, prob = pa, lower.tail = FALSE)
        }, two.sided = {
            lx <- qbinom(sig.level, size = n, prob = p0)
            ux <- qbinom(sig.level, size = n, prob = p0, lower.tail = FALSE)
            x <- c(seq(0, lx), seq(ux, n))
            d <- dbinom(x, size = n, prob = p0)
            ordd <- order(d)
            cs <- cumsum(sort(d))
            xval <- which.min(cs < sig.level) - 1
            ssh <- d[ordd[xval]]
            relErr <- 1 + 1e-07
            m <- n * p0
            if (xval == 0) return(0)
            if (x[ordd[xval]] < m) {
                i <- seq.int(from = ux, to = n)
                y <- sum(dbinom(i, n, p0) <= ssh * relErr)
                pbinom(x[ordd[xval]], size = n, prob = pa) + 
                  pbinom(n - y, size = n, prob = pa, lower.tail = FALSE)
            } else {
                i <- seq.int(from = 0, to = lx)
                y <- sum(dbinom(i, n, p0) <= ssh * relErr)
                pbinom(y - 1, size = n, prob = pa) + pbinom(x[ordd[xval]] - 
                  1, n, pa, lower.tail = FALSE)
            }
        })
        power
    }
    p.body <- Vectorize(pfun)
    ppp <- body(p.body)
    qqq <- quote({
        do.call("mapply", c(FUN = pfun, list(n, p0, pa, sig.level, 
            alternative), SIMPLIFY = TRUE, USE.NAMES = TRUE))
    })
    if (is.null(power)) 
        power <- eval(qqq)
    else if (is.null(n)) {
        ans <- uniroot(function(n) eval(qqq) - power, c(2, 1e+06))
        n <- ans$root + (ans$f.root < 0)
    }
    else if (is.null(p0)) 
        p0 <- uniroot(function(p0) eval(p.body) - power, c(1e-07, 
            1 - 1e-07))$root
    else if (is.null(pa)) 
        pa <- uniroot(function(pa) eval(p.body) - power, c(1e-07, 
            1 - 1e-07))$root
    else if (is.null(sig.level)) 
        sig.level <- uniroot(function(sig.level) eval(p.body) - 
            power, c(1e-10, 1 - 1e-10))$root
    else stop("internal error", domain = NA)
    NOTE <- NULL
    METHOD <- "One-sample exact binomial power calculation"
    structure(list(n = n, p0 = p0, pa = pa, sig.level = sig.level, 
        power = power, alternative = alternative, note = NOTE, 
        method = METHOD), class = "power.htest")
  }
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ htest }
