% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MCMC.tree.plot.R
\name{MCMC.tree.plot}
\alias{MCMC.tree.plot}
\title{Plot time-scaled phylogenies}
\usage{
MCMC.tree.plot(phy = NULL, analysis.type = "MCMCtree",
  MCMC.chain = NULL, node.ages = NULL, directory.files = NULL,
  plot.type = "phylogram", build.tree = FALSE, node.method = "bar",
  all.nodes = NULL, add.time.scale = TRUE, add.abs.time = TRUE,
  scale.res = "Epoch", label.timescale.names = FALSE,
  time.correction = 1, col.age = "blue", tip.lengths = FALSE,
  density.col = "#00000050", density.border.col = "#00000080",
  cex.tips = 1, show.tip.label = TRUE, col.tree = "black",
  tip.color = "black", lwd.bar = 1, grey.bars = TRUE, cex.age = 1,
  cex.labels = 1, cex.names = 1, relative.height = 0.08,
  tip.bar.col = "#ff000050", burn.in = 0.25,
  distribution.height = 0.8, abs.age.mgp = c(3, 0.35, 0),
  abs.age.lwd.ticks = 0.7, abs.age.lwd = 0, tck.abs.age = -0.01,
  abs.age.line = -0.4, pos.age = NULL, n.runs = 2, ...)
}
\arguments{
\item{phy}{A timescaled phylogeny, unless analysis.type="MCMCtree" and build.tree=TRUE}

\item{analysis.type}{The method used to generate the time-scale tree, one of MCMCtree, MrBayes, RevBayes, or User.}

\item{MCMC.chain}{The full posterior of age estimates for all nodes (default NULL)}

\item{node.ages}{List of user-supplied node ages applicable for analysis.type user. Either all nodes or a selection of nodes. Each list element must be named with its corresponding node label from the APE format.}

\item{directory.files}{The directory for files to summarise for MrBayes and RevBayes analyses}

\item{plot.type}{The plotting method for the phylogram corresponding to the APE definition. Phylogram is available for all analysis types, but cladogram is only avilable for MCMCtree analyses at present. Type distributions plots a phylogram with stats::density distributions on each of the nodes.}

\item{build.tree}{Logical. Only applicable to MCMCtree analyses, whether to timescale the phylogeny based on the full MCMC chain}

\item{node.method}{For plot.type phylogram the method to dispay age uncertainty on each node, either bar, node.length, or full.length. If 'none' is supplied plotting node uncertainty is suppressed.}

\item{all.nodes}{If NULL (default) node uncertainty is plotted on all nodes. If node numbers are supplied, only these nodes will be labelled with uncertainty.}

\item{add.time.scale}{Logical. Adds a timescale to the plotted phylogeny.}

\item{add.abs.time}{Logical. Adds an absolute timescale alongside the geological timescale. Only applicable if add.time.scale is TRUE}

\item{scale.res}{The geological age designation to add to the plot can be one or a combination of Eon, Period, Epoch, Age. The order of plot (from bottom to top) is the same as the supplied order. Subsequent arguments add.abs.time and grey.bars are based on the last supplied age designation.}

\item{label.timescale.names}{Logical. Add names (Eon, Period, Epoch, Age, Ma) to axis if timescale used}

\item{time.correction}{Number to place branch lengths and age estimates in absolute time, deafult to one.}

\item{col.age}{The colouring of the node.method bars to summarise node age uncertainty}

\item{tip.lengths}{Logical. If the tree contains non-present tip ages, the age uncertainty associated with them will be added to the plot}

\item{density.col}{Colour of the node distributions (if analysis.type=distributions)}

\item{density.border.col}{Colour of the node distributions (if analysis.type=distributions) borders}

\item{cex.tips}{Size of the phylogeny tip labels}

\item{show.tip.label}{Logical. Should the tree tip labels be displayed}

\item{col.tree}{Colour of the phylogeny edges}

\item{tip.color}{Colour of the phylogeny tip labels}

\item{lwd.bar}{Width of the bar to summarise age uncertainty, applicable only if plot.type is phylogram and node.method is bar}

\item{grey.bars}{Logical. Should grey bars be used to signify time bins, applicable only if add.time.scale is TRUE}

\item{cex.age}{Size of the labels for the absolute timescale}

\item{cex.labels}{Size of the labels for the geological timescale}

\item{cex.names}{Logical. Add label.timescale.names, if applicable.}

\item{relative.height}{the relative height of the timescale labels}

\item{tip.bar.col}{The colour of uncertainty around non-contemporary tips}

\item{burn.in}{The number of points in the chain to discard for MrBayes and RevBayes analyses}

\item{distribution.height}{The relative height of node distributions when plot.type is distributions measured as the relative height of the descendent node}

\item{abs.age.mgp}{mgp values for the absolute age axis, only applicable if add.abs.time is TRUE}

\item{abs.age.lwd.ticks}{lwd values for the absolute age axis ticks, only applicable if add.abs.time is TRUE}

\item{abs.age.lwd}{lwd values for the absolute age axis horizontal line, only applicable if add.abs.time is TRUE}

\item{tck.abs.age}{tck values for the absolute age axis tick height, only applicable if add.abs.time is TRUE}

\item{abs.age.line}{line correction for the absolute age axis tick, only applicable if add.abs.time is TRUE}

\item{pos.age}{position position of absolute age axis}

\item{n.runs}{For analysis.type mrbayes, the number of independent chains to summarise}

\item{...}{further arguments to be used in \code{\link[ape]{plot.phylo}}}
}
\value{
If plot=TRUE plot of distributions in file 'pdfOutput' written to current working directory
}
\description{
Plot time-scaled phylogenies with node uncertainty and timescale
}
\examples{
data(MCMCtree.output)
attach(MCMCtree.output)
MCMCtree.file <- readMCMCtree(MCMCtree.phy, from.file=FALSE)
MCMC.tree.plot(MCMCtree.file[[1]],  analysis.type="MCMCtree",
MCMC.chain=MCMCtree.posterior, plot.type="distributions", cex.tips=0.5)
}
