% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write.functions.R
\name{time.fun}
\alias{time.fun}
\title{Write time-course function component of JAGS code for MBNMA time-course
models}
\usage{
\method{time}{fun}(fun = "linear", user.fun = NULL, alpha = "arm",
  beta.1 = "rel.common", beta.2 = NULL, beta.3 = NULL,
  beta.4 = NULL)
}
\arguments{
\item{fun}{is a character specifying a functional form to be assigned to the
time-course. Options are given in \code{details}.}

\item{user.fun}{A character specifying any relationship including \code{time} and
one/several of: \code{alpha}, \code{beta.1}, \code{beta.2}, \code{beta.3}, \code{beta.4}.}

\item{alpha}{Refers to the baseline mean response and is a character object
that can take either:
\itemize{
\item \code{"study"} to constrain baseline to be equal for all
arms within a study (\code{i} index is added))
\item \code{"arm"} to allow baseline to
vary between arms within a study (\code{i,k} index is added)).
}}

\item{beta.1}{A list with named elements \code{pool} and \code{method} that refers to
time-course parameter(s) specified within the time-course function (see details).}

\item{beta.2}{A list with named elements \code{pool} and \code{method} that refers to
time-course parameter(s) specified within the time-course function (see details).}

\item{beta.3}{A list with named elements \code{pool} and \code{method} that refers to
time-course parameter(s) specified within the time-course function (see details).}

\item{beta.4}{A list with named elements \code{pool} and \code{method} that refers to
time-course parameter(s) specified within the time-course function (see details).}
}
\value{
A single character string containing JAGS model representing the
time-course function component of an MBNMA time-course model, generated
based on the arguments passed to the function.
}
\description{
Writes a single line of JAGS code representing the time-course function
component of an MBNMA time-course model, outputted as a single character
string.
}
