% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Script_PLATE_03_COMPUTE_PSI_1_Compute_SE.R
\name{ComputePSI.SE}
\alias{ComputePSI.SE}
\title{Compute skipped-exon (SE) percent spliced-in (PSI) values}
\usage{
ComputePSI.SE(MarvelObject, CoverageThreshold, UnevenCoverageMultiplier = 10)
}
\arguments{
\item{MarvelObject}{S3 object generated from \code{CreateMarvelObject} function.}

\item{CoverageThreshold}{Numeric value. Coverage threshold below which the PSI of the splicing event will be censored, i.e. annotated as missing (NA). Coverage defined as the total number of reads supporting both included and excluded isoforms.}

\item{UnevenCoverageMultiplier}{Numeric value. Maximum allowable fold difference between two included junction counts.}
}
\value{
An object of class S3 with new slots \code{$SpliceFeatureValidated$SE}  \code{$PSI$SE}.
}
\description{
Validate SE splicing events and subsequently computes percent spliced-in (PSI) values these high-quality splicing events.
}
\details{
This function computes the PSI for each SE splicing event. Splicing events provided in \code{SpliceFeature} data frame will first be cross-checked against the splice junctions provided in \code{SpliceJunction} data frame. Only events whose junctions are found in \code{SpliceJunction} are retained. The formula for computing PSI is the number of junction reads supporting the included isoform divided by the total number of reads supporting both included and excluded isoforms.
}
\examples{
marvel.demo <- readRDS(system.file("extdata/data", "marvel.demo.rds", package="MARVEL"))

marvel.demo <- ComputePSI.SE(MarvelObject=marvel.demo,
                             CoverageThreshold=10,
                             UnevenCoverageMultiplier=10
                             )
}
