% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/orthMappingCpx.R
\name{orthMappingCpx}
\alias{orthMappingCpx}
\title{Protein Complex Ortholog Mapping}
\usage{
orthMappingCpx(
  datInput,
  input_species,
  output_species,
  input_taxid,
  output_taxid
)
}
\arguments{
\item{datInput}{A list containing reference complexes (i.e.,
CORUM complexes). Note that the members of each complexes must be
represented by UniProt accession identifier.}

\item{input_species}{Name of the input species (e.g., "mouse","fly").
See \code{\link[orthogene]{map_species}} to return a full list of
available species.}

\item{output_species}{Name of the output species (e.g., "human").
See \code{\link[orthogene]{map_species}} to return a full list of
available species.}

\item{input_taxid}{A numeric value that specifies the NCBI
taxonomy identifier (TaxId) for input organism (e.g., 10090).}

\item{output_taxid}{A numeric value that specifies the NCBI
taxonomy identifier (TaxId) for output organism.}
}
\value{
A list containing complexes, whose members
converted to output_species.
}
\description{
This function uses \code{\link[orthogene]{convert_orthologs}}
function to support ortholog mapping of protein complexes between any pair
of 700+ species.
}
\details{
orthMappingCpx
}
\author{
Matineh Rahmatbakhsh, \email{matinerb.94@gmail.com}
}
