/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.utils;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerRange
extends AbstractList<Integer> {
    private int start;
    private int step;
    private int length;

    public IntegerRange(int end) {
        this(0, end, 1);
    }

    public IntegerRange(int start, int end) {
        this(start, end, 1);
    }

    public IntegerRange(int start, int end, int step) {
        this.start = start;
        this.step = step;
        this.length = (int)Math.ceil((double)(end - start) / (double)step);
        if (this.length < 0) {
            this.length = 0;
        }
    }

    @Override
    public Integer get(int index) {
        if (index < 0 || index >= this.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.start + this.step * index;
    }

    @Override
    public Iterator<Integer> iterator() {
        return new IteratorImpl(0);
    }

    @Override
    public ListIterator<Integer> listIterator() {
        return new IteratorImpl(0);
    }

    @Override
    public ListIterator<Integer> listIterator(int index) {
        return new IteratorImpl(index);
    }

    @Override
    public int size() {
        return this.length;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class IteratorImpl
    implements ListIterator<Integer> {
        int index;

        public IteratorImpl(int index) {
            this.index = index;
            if (index < 0 || index >= IntegerRange.this.length) {
                throw new IndexOutOfBoundsException("List index out of bounds: " + index);
            }
        }

        @Override
        public void add(Integer arg0) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean hasNext() {
            return this.index < IntegerRange.this.length;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public Integer next() {
            int result = IntegerRange.this.start + this.index * IntegerRange.this.step;
            if (this.index >= IntegerRange.this.length) {
                throw new NoSuchElementException();
            }
            ++this.index;
            return result;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public Integer previous() {
            --this.index;
            int result = IntegerRange.this.start + this.index * IntegerRange.this.step;
            if (this.index < 0) {
                throw new NoSuchElementException();
            }
            return result;
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void set(Integer arg0) {
            throw new UnsupportedOperationException();
        }
    }
}

