/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.rhul.cs.graph;

import uk.ac.rhul.cs.graph.Directedness;
import uk.ac.rhul.cs.graph.Graph;
import uk.ac.rhul.cs.graph.GraphAlgorithm;

public class TransitivityCalculator
extends GraphAlgorithm {
    public TransitivityCalculator() {
    }

    public TransitivityCalculator(Graph graph) {
        super(graph);
    }

    public Double getAverageLocalTransitivity() {
        throw new RuntimeException("average local transitivity not implemented yet");
    }

    public Double getGlobalTransitivity() {
        long triangles = 0L;
        long triplets = 0L;
        int nodeCount = this.graph.getNodeCount();
        this.shouldStop = false;
        for (int i = 0; i < nodeCount; ++i) {
            int[] neis;
            if (this.shouldStop) {
                return null;
            }
            for (int j : neis = this.graph.getAdjacentNodeIndicesArray(i, Directedness.ALL)) {
                if (j <= i) continue;
                for (int k : neis) {
                    if (j >= k || !this.graph.areConnected(j, k)) continue;
                    ++triangles;
                }
            }
            triplets += (long)(neis.length * (neis.length - 1) / 2);
        }
        return triplets == 0L ? 0.0 : 3.0 * (double)triangles / (double)triplets;
    }

    public void setGraph(Graph graph) {
        if (graph.isDirected()) {
            throw new UnsupportedOperationException("transitivity calculation works for undirected graphs only");
        }
        super.setGraph(graph);
    }
}

