% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_RLum.R
\name{plot_RLum}
\alias{plot_RLum}
\title{General plot function for RLum S4 class objects}
\usage{
plot_RLum(object, ...)
}
\arguments{
\item{object}{\linkS4class{RLum} (\strong{required}):
S4 object of class \code{RLum}. Optional a \link{list} containing objects of
class \linkS4class{RLum} can be provided. In this case the function tries to plot
every object in this list according to its \code{RLum} class. Non-RLum objects are
removed.}

\item{...}{further arguments and graphical parameters that will be passed
to the specific plot functions. The only argument that is supported directly is \code{main}
(setting the plot title). In contrast to the normal behaviour \code{main} can be here provided as
\link{list} and the arguments in the list will dispatched to the plots if the \code{object}
is of type \code{list} as well.}
}
\value{
Returns a plot.
}
\description{
Function calls object specific plot functions for RLum S4 class objects.
}
\details{
The function provides a generalised access point for plotting specific
\linkS4class{RLum} objects.\cr
Depending on the input object, the
corresponding plot function will be selected.  Allowed arguments can be
found in the documentations of each plot function.

\tabular{lll}{
\strong{object} \tab \tab \strong{corresponding plot function} \cr
\linkS4class{RLum.Data.Curve} \tab : \tab \link{plot_RLum.Data.Curve} \cr
\linkS4class{RLum.Data.Spectrum} \tab : \tab \link{plot_RLum.Data.Spectrum}\cr
\linkS4class{RLum.Data.Image} \tab : \tab \link{plot_RLum.Data.Image}\cr
\linkS4class{RLum.Analysis} \tab : \tab \link{plot_RLum.Analysis}\cr
\linkS4class{RLum.Results} \tab : \tab \link{plot_RLum.Results}
}
}
\note{
The provided plot output depends on the input object.
}
\section{Function version}{
 0.4.4
}

\examples{
#load Example data
data(ExampleData.CW_OSL_Curve, envir = environment())

#transform data.frame to RLum.Data.Curve object
temp <- as(ExampleData.CW_OSL_Curve, "RLum.Data.Curve")

#plot RLum object
plot_RLum(temp)

}
\seealso{
\link{plot_RLum.Data.Curve}, \linkS4class{RLum.Data.Curve}, \link{plot_RLum.Data.Spectrum},
\linkS4class{RLum.Data.Spectrum}, \link{plot_RLum.Data.Image}, \linkS4class{RLum.Data.Image},
\link{plot_RLum.Analysis}, \linkS4class{RLum.Analysis}, \link{plot_RLum.Results},
\linkS4class{RLum.Results}
}
\author{
Sebastian Kreutzer, Institute of Geography, Heidelberg University (Germany)
, RLum Developer Team} 

\section{How to cite}{
Kreutzer, S., 2025. plot_RLum(): General plot function for RLum S4 class objects. Function version 0.4.4. In: Kreutzer, S., Burow, C., Dietze, M., Fuchs, M.C., Schmidt, C., Fischer, M., Friedrich, J., Mercier, N., Philippe, A., Riedesel, S., Autzen, M., Mittelstrass, D., Gray, H.J., Galharret, J., Colombo, M., Steinbuch, L., Boer, A.d., 2025. Luminescence: Comprehensive Luminescence Dating Data Analysis. R package version 1.0.0. https://r-lum.github.io/Luminescence/
}

\keyword{dplot}
