% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Luminescence-package.R
\name{BaseDataSet.ConversionFactors}
\alias{BaseDataSet.ConversionFactors}
\title{Base data set of dose-rate conversion factors}
\format{
A \code{\link{list}} with three elements with dose-rate conversion factors
sorted by article and radiation type (alpha, beta, gamma):

\tabular{ll}{

\code{AdamiecAitken1998}: \tab
Conversion factors from Tables 5 and 6 \cr

\code{Cresswelletal2018}: \tab
Conversion factors from Tables 5 and 6 \cr

\code{Guerinetal2011}: \tab
Conversion factors from Tables 1, 2 and 3 \cr

\code{Liritzisetal2013}: \tab
Conversion factors from Tables 1, 2 and 3 \cr
}
}
\source{
All gamma conversion factors were carefully read from the tables given in the
references above.
}
\description{
Collection of published dose-rate conversion factors to convert concentrations
of radioactive isotopes to dose rate values.
}
\section{Version}{
 0.2.0
}

\examples{

## Load data
data("BaseDataSet.ConversionFactors", envir = environment())

}
\references{
Adamiec, G., Aitken, M.J., 1998. Dose-rate conversion factors: update.
Ancient TL 16, 37-46.

Cresswell., A.J., Carter, J., Sanderson, D.C.W., 2018.
Dose rate conversion parameters: Assessment of nuclear data.
Radiation Measurements 120, 195-201.

Guerin, G., Mercier, N., Adamiec, G., 2011. Dose-rate conversion
factors: update. Ancient TL, 29, 5-8.

Liritzis, I., Stamoulis, K., Papachristodoulou, C., Ioannides, K., 2013.
A re-evaluation of radiation dose-rate conversion factors. Mediterranean
Archaeology and Archaeometry 13, 1-15.
}
\keyword{datasets}
